/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import java.nio.ByteBuffer;

public interface PixelRectangle {
    public int hashCode();

    public PixelFormat getPixelformat();

    public DimensionImmutable getSize();

    public int getStride();

    public boolean isGLOriented();

    public ByteBuffer getPixels();

    public String toString();

    public static class GenericPixelRect
    implements PixelRectangle {
        protected final PixelFormat pixelformat;
        protected final DimensionImmutable size;
        protected final int strideInBytes;
        protected final boolean isGLOriented;
        protected final ByteBuffer pixels;
        private int hashCode = 0;
        private volatile boolean hashCodeComputed = false;

        public GenericPixelRect(PixelFormat pixelFormat, DimensionImmutable dimensionImmutable, int n, boolean bl, ByteBuffer byteBuffer) throws IllegalArgumentException, IndexOutOfBoundsException {
            if (0 != n) {
                if (n < pixelFormat.comp.bytesPerPixel() * dimensionImmutable.getWidth()) {
                    throw new IllegalArgumentException("Invalid stride " + n + ", must be greater than bytesPerPixel " + pixelFormat.comp.bytesPerPixel() + " * width " + dimensionImmutable.getWidth());
                }
            } else {
                n = pixelFormat.comp.bytesPerPixel() * dimensionImmutable.getWidth();
            }
            int n2 = n * dimensionImmutable.getHeight();
            if (byteBuffer.limit() < n2) {
                throw new IndexOutOfBoundsException("Dest buffer has insufficient bytes left, needs " + n2 + ": " + byteBuffer);
            }
            this.pixelformat = pixelFormat;
            this.size = dimensionImmutable;
            this.strideInBytes = n;
            this.isGLOriented = bl;
            this.pixels = byteBuffer;
        }

        public GenericPixelRect(PixelRectangle pixelRectangle) throws IllegalArgumentException, IndexOutOfBoundsException {
            this(pixelRectangle.getPixelformat(), pixelRectangle.getSize(), pixelRectangle.getStride(), pixelRectangle.isGLOriented(), pixelRectangle.getPixels());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            if (!this.hashCodeComputed) {
                GenericPixelRect genericPixelRect = this;
                synchronized (genericPixelRect) {
                    if (!this.hashCodeComputed) {
                        int n = this.pixelformat.comp.hashCode();
                        n = (n << 5) - n + this.size.hashCode();
                        n = (n << 5) - n + this.strideInBytes;
                        n = (n << 5) - n + (this.isGLOriented ? 1 : 0);
                        this.hashCode = (n << 5) - n + this.pixels.hashCode();
                        this.hashCodeComputed = true;
                    }
                }
            }
            return this.hashCode;
        }

        @Override
        public PixelFormat getPixelformat() {
            return this.pixelformat;
        }

        @Override
        public DimensionImmutable getSize() {
            return this.size;
        }

        @Override
        public int getStride() {
            return this.strideInBytes;
        }

        @Override
        public boolean isGLOriented() {
            return this.isGLOriented;
        }

        @Override
        public ByteBuffer getPixels() {
            return this.pixels;
        }

        @Override
        public final String toString() {
            return "PixelRect[obj 0x" + Integer.toHexString(super.hashCode()) + ", " + (Object)((Object)this.pixelformat) + ", " + this.size + ", stride " + this.strideInBytes + ", isGLOrient " + this.isGLOriented + ", pixels " + this.pixels + "]";
        }
    }
}

