/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Coverage;
import jogamp.graph.font.typecast.ot.table.SingleSubst;

public class SingleSubstFormat1
extends SingleSubst {
    private final int _coverageOffset;
    private final short _deltaGlyphID;
    private final Coverage _coverage;

    protected SingleSubstFormat1(DataInputStream dataInputStream, int n) throws IOException {
        this._coverageOffset = dataInputStream.readUnsignedShort();
        this._deltaGlyphID = dataInputStream.readShort();
        dataInputStream.reset();
        dataInputStream.skipBytes(n + this._coverageOffset);
        this._coverage = Coverage.read(dataInputStream);
    }

    @Override
    public int getFormat() {
        return 1;
    }

    @Override
    public int substitute(int n) {
        int n2 = this._coverage.findGlyph(n);
        if (n2 > -1) {
            return n + this._deltaGlyphID;
        }
        return n;
    }

    @Override
    public String getTypeAsString() {
        return "SingleSubstFormat1";
    }
}

