/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.project.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RecentFiles
extends AbstractAction
implements DynamicMenuContent {
    RecentFiles() {
        super(NbBundle.getMessage(RecentFiles.class, (String)"CTL_OpenRecentFiles"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public JComponent[] getMenuPresenters() {
        return this.createMenu();
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.createMenu();
    }

    private JComponent[] createMenu() {
        JComponent[] menuItems;
        JMenu menu = new JMenu(NbBundle.getMessage(RecentFiles.class, (String)"CTL_OpenRecentFiles"));
        for (JComponent item : menuItems = this.createSubMenus()) {
            menu.add(item);
        }
        return new JComponent[]{menu};
    }

    private JComponent[] createSubMenus() {
        ArrayList<JMenuItem> projectsItems = new ArrayList<JMenuItem>();
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        for (Project project : projectController.getAllProjects()) {
            if (!project.hasFile()) continue;
            JMenuItem menuItem = new JMenuItem(new OpenProjectAction(project));
            projectsItems.add(menuItem);
        }
        MostRecentFiles mru = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        List filesItems = mru.getMRUFileList().stream().map(File::new).filter(File::exists).map(f -> new JMenuItem(new OpenFileAction((File)f))).collect(Collectors.toList());
        ArrayList<JComponent> items = new ArrayList<JComponent>(projectsItems);
        if (!projectsItems.isEmpty() && !filesItems.isEmpty()) {
            items.add(new JSeparator());
        }
        items.addAll(filesItems);
        items.add(new JSeparator());
        items.add(new JMenuItem(Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.ManageProjects")));
        return items.toArray(new JComponent[0]);
    }

    private static class OpenProjectAction
    extends AbstractAction {
        private final Project project;

        public OpenProjectAction(Project project) {
            super(OpenProjectAction.getActionName(project));
            this.project = project;
        }

        private static String getActionName(Project project) {
            return project.getName() + " (" + project.getFileName() + ")";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = this.project.getFile();
            Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.OpenFile").actionPerformed(new ActionEvent(file, 0, null));
        }
    }

    private static class OpenFileAction
    extends AbstractAction {
        private final File file;

        public OpenFileAction(File file) {
            super(file.getName());
            this.file = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject fileObject = FileUtil.toFileObject((File)this.file);
            ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
            if (importController.getImportController().isFileSupported(this.file)) {
                importController.importFile(fileObject);
            }
        }
    }
}

