/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import net.java.dev.colorchooser.CCBorder;
import net.java.dev.colorchooser.ColorChooser;
import net.java.dev.colorchooser.ColorChooserUI;
import net.java.dev.colorchooser.ColorParser;

final class DefaultColorChooserUI
extends ColorChooserUI {
    private static DefaultColorChooserUI INSTANCE = null;
    private static final FontChangeListener FONT_CHANGE = new FontChangeListener();
    private static Boolean MAC;

    DefaultColorChooserUI() {
    }

    public static ComponentUI createUI(JComponent jc) {
        return DefaultColorChooserUI.getDefault();
    }

    static DefaultColorChooserUI getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultColorChooserUI();
        }
        return INSTANCE;
    }

    @Override
    protected void init(ColorChooser c) {
        String uiFontSize;
        Font f = UIManager.getFont("controlFont");
        if (f == null) {
            f = UIManager.getFont("Label.font");
        }
        if (f == null) {
            f = new JLabel().getFont();
        }
        if ((uiFontSize = System.getProperty("uiFontSize")) != null) {
            try {
                f = f.deriveFont(Float.parseFloat(uiFontSize));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        c.setFont(f);
        c.setToolTipText(DefaultColorChooserUI.getDefaultTooltip());
        c.setBorder(new CCBorder());
        c.setFocusable(true);
        c.setOpaque(true);
        ActionMap am = c.getActionMap();
        InputMap im = c.getInputMap();
        KeyStroke copy1 = DefaultColorChooserUI.isMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke copy2 = KeyStroke.getKeyStroke(65485, 0);
        KeyStroke paste1 = DefaultColorChooserUI.isMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        KeyStroke paste2 = KeyStroke.getKeyStroke(65487, 0);
        im.put(copy1, "copy");
        im.put(copy2, "copy");
        am.put("copy", new CcCopyAction(c));
        im.put(paste1, "paste");
        im.put(paste2, "paste");
        am.put("paste", new CcPasteAction(c));
        c.addPropertyChangeListener("font", FONT_CHANGE);
    }

    static boolean isMac() {
        if (MAC != null) {
            return MAC;
        }
        MAC = System.getProperty("os.name", "x").toLowerCase().contains("darwin") || System.getProperty("mrj.version") != null;
        return MAC;
    }

    @Override
    protected void uninit(ColorChooser c) {
        if (c.getBorder() instanceof CCBorder) {
            c.setBorder(null);
        }
        if (DefaultColorChooserUI.getDefaultTooltip().equals(c.getToolTipText())) {
            c.setToolTipText(null);
        }
        c.removePropertyChangeListener("font", FONT_CHANGE);
    }

    private static String getDefaultTooltip() {
        return DefaultColorChooserUI.isMac() ? ColorChooser.getString("tip.mac") : ColorChooser.getString("tip");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color col;
        ColorChooser chooser = (ColorChooser)c;
        Color color = col = chooser.transientColor() != null ? chooser.transientColor() : chooser.getColor();
        if (col.getAlpha() != 255) {
            int halfWidth = chooser.getWidth() / 2;
            int halfHeight = chooser.getHeight() / 2;
            Color gray1 = new Color(128, 128, 128);
            Color gray2 = new Color(164, 164, 164);
            g.setColor(gray1);
            g.fillRect(0, 0, halfWidth, halfHeight);
            g.fillRect(halfWidth, halfHeight, halfWidth, halfHeight);
            g.setColor(gray2);
            g.fillRect(halfWidth, 0, halfWidth, halfHeight);
            g.fillRect(0, halfHeight, halfWidth, halfHeight);
        }
        g.setColor(col);
        g.fillRect(0, 0, chooser.getWidth() - 1, chooser.getHeight() - 1);
        if (chooser.hasFocus()) {
            g.setColor(DefaultColorChooserUI.invertColor(col));
            g.drawRect(4, 4, chooser.getWidth() - 8, chooser.getHeight() - 8);
        }
    }

    private static final Color invertColor(Color c) {
        int r = DefaultColorChooserUI.checkRange(255 - c.getRed());
        int g = DefaultColorChooserUI.checkRange(255 - c.getGreen());
        int b = DefaultColorChooserUI.checkRange(255 - c.getBlue());
        return new Color(r, g, b);
    }

    private static final int checkRange(int i) {
        int result = i;
        if (Math.abs(128 - i) < 24) {
            result = Math.abs(128 - i);
        }
        return result;
    }

    private static final class CcPasteAction
    extends AbstractAction {
        private final ColorChooser chooser;

        CcPasteAction(ColorChooser chooser) {
            this.putValue("Name", "paste");
            this.chooser = chooser;
        }

        @Override
        public boolean isEnabled() {
            for (DataFlavor df : Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors()) {
                if (!DataFlavor.stringFlavor.equals(df)) continue;
                try {
                    String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    return ColorParser.canParse(data);
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(DefaultColorChooserUI.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String str = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                Color color = ColorParser.parse(str);
                if (color != null) {
                    this.chooser.setColor(color);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(DefaultColorChooserUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static final class CcCopyAction
    extends AbstractAction {
        private final ColorChooser chooser;

        CcCopyAction(ColorChooser chooser) {
            this.putValue("Name", "copy");
            this.chooser = chooser;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color c = this.chooser.getColor();
            String txt = ColorParser.toMinimalString(c);
            StringSelection sel = new StringSelection(txt);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
        }
    }

    static final class FontChangeListener
    implements PropertyChangeListener {
        FontChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ColorChooser && "font".equals(evt.getPropertyName())) {
                ColorChooser cc = (ColorChooser)evt.getSource();
                cc.invalidate();
                cc.revalidate();
                cc.repaint();
            }
        }
    }
}

