/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import java.util.List;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;

final class AndValidator<T>
extends AbstractValidator<T> {
    private final List<Validator<T>> validators;

    AndValidator(Class<T> type, List<Validator<T>> initial) {
        super(type);
        this.validators = initial;
        assert (this.validatorTypesMatch(initial)) : "Validator type mismatch: " + this.validators;
    }

    @Override
    public void validate(Problems problems, String compName, T model) {
        for (Validator<T> v : this.validators) {
            v.validate(problems, compName, model);
        }
    }

    public String toString() {
        return "AndValidator for " + this.validators;
    }

    private boolean validatorTypesMatch(List<? extends Validator<?>> validators) {
        Class<?> type = null;
        for (Validator<?> v : validators) {
            if (type == null) {
                type = v.modelType();
                continue;
            }
            if (type.equals(v.modelType())) continue;
            return false;
        }
        return true;
    }
}

