/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import org.netbeans.validation.api.Severity;

public final class Problem
implements Comparable<Problem> {
    private final String message;
    private final Severity severity;

    public Problem(String message, Severity severity) {
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        if (severity == null) {
            throw new NullPointerException("Null severity");
        }
        this.message = message;
        this.severity = severity;
    }

    public Severity severity() {
        return this.severity;
    }

    public static Problem worst(Problem p1, Problem p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return p2.compareTo(p1) < 0 ? p2 : p1;
    }

    public boolean isFatal() {
        return this.severity == Severity.FATAL;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public int compareTo(Problem o) {
        int ix = this.severity.ordinal();
        int oid = o == null ? -1 : o.severity.ordinal();
        return oid - ix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != Problem.class) {
            return false;
        }
        Problem p = (Problem)o;
        return p.severity == this.severity && p.getMessage().equals(this.getMessage());
    }

    public String toString() {
        return this.getMessage() + " (" + (Object)((Object)this.severity()) + ")";
    }

    public int hashCode() {
        return this.message.hashCode() * (this.severity.hashCode() + 1);
    }
}

