/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.query;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Action;
import org.gephi.desktop.filters.library.FilterBuilderNode;
import org.gephi.desktop.filters.library.SavedQueryNode;
import org.gephi.desktop.filters.query.QueryNode;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.FilterBuilder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class RootNode
extends AbstractNode {
    public RootNode(Children children) {
        super(children);
        this.setName(NbBundle.getMessage(RootNode.class, (String)"RootNode.name"));
        this.setIconBaseWithExtension("DesktopFilters/queries.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)3);
        if (t.isDataFlavorSupported(FilterBuilderNode.DATA_FLAVOR)) {
            try {
                final FilterBuilder fb = (FilterBuilder)t.getTransferData(FilterBuilderNode.DATA_FLAVOR);
                return new PasteType(){

                    public Transferable paste() throws IOException {
                        FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                        Query f = filterController.createQuery(fb);
                        filterController.add(f);
                        return null;
                    }
                };
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            if (dropNode != null && dropNode instanceof SavedQueryNode) {
                return new PasteType(){

                    public Transferable paste() throws IOException {
                        SavedQueryNode node = (SavedQueryNode)dropNode;
                        FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                        filterController.add(node.getQuery());
                        return null;
                    }
                };
            }
            if (dropNode != null && dropNode instanceof QueryNode && ((QueryNode)dropNode).getQuery().getParent() != null) {
                return new PasteType(){

                    public Transferable paste() throws IOException {
                        QueryNode queryNode = (QueryNode)dropNode;
                        FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                        filterController.removeSubQuery(queryNode.getQuery(), queryNode.getQuery().getParent());
                        filterController.add(queryNode.getQuery());
                        return null;
                    }
                };
            }
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }
}

