/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class SwitchToRecentDocumentAction
extends AbstractAction
implements PropertyChangeListener {
    public SwitchToRecentDocumentAction() {
        this.putValue("Name", NbBundle.getMessage(SwitchToRecentDocumentAction.class, (String)"CTL_SwitchToRecentDocumentAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        String[] ids = wm.getRecentViewIDList();
        if (ids.length == 0) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            TopComponent tc;
            String tcId = ids[i];
            ModeImpl mode = wm.findModeForOpenedID(tcId);
            if (mode == null || mode.getKind() != 1) continue;
            if (mode != wm.getCurrentMaximizedMode()) {
                wm.switchMaximizedMode(null);
            }
            if (null == (tc = wm.findTopComponent(tcId))) continue;
            tc.requestActive();
            break;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("opened".equals(evt.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        for (ModeImpl modeImpl : WindowManagerImpl.getInstance().getModes()) {
            if (modeImpl.getKind() != 1 || modeImpl.getOpenedTopComponents().isEmpty()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

