/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.desktop.appearance.AppearanceUIModelEvent;
import org.gephi.desktop.appearance.AppearanceUIModelListener;
import org.gephi.desktop.appearance.AutoAppyTransformer;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.Lookup;

public class AppearanceUIController {
    protected static final String NODE_ELEMENT = "nodes";
    protected static final String EDGE_ELEMENT = "edges";
    protected static final String[] ELEMENT_CLASSES = new String[]{"nodes", "edges"};
    protected final Map<String, Map<TransformerCategory, Set<TransformerUI>>> transformers;
    protected final AppearanceController appearanceController;
    private final Set<AppearanceUIModelListener> listeners;
    private AppearanceUIModel model;

    public AppearanceUIController() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.appearanceController = (AppearanceController)Lookup.getDefault().lookup(AppearanceController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                AppearanceUIModel oldModel = AppearanceUIController.this.model;
                AppearanceUIController.this.model = (AppearanceUIModel)workspace.getLookup().lookup(AppearanceUIModel.class);
                if (AppearanceUIController.this.model == null) {
                    AppearanceModel appearanceModel = AppearanceUIController.this.appearanceController.getModel(workspace);
                    AppearanceUIController.this.model = new AppearanceUIModel(appearanceModel);
                    workspace.add((Object)AppearanceUIController.this.model);
                }
                AppearanceUIController.this.model.select();
                AppearanceUIController.this.firePropertyChangeEvent(AppearanceUIModelEvent.MODEL, oldModel, AppearanceUIController.this.model);
            }

            public void unselect(Workspace workspace) {
                if (AppearanceUIController.this.model != null) {
                    AppearanceUIController.this.model.unselect();
                }
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                AppearanceUIModel oldModel = AppearanceUIController.this.model;
                AppearanceUIController.this.model = null;
                AppearanceUIController.this.firePropertyChangeEvent(AppearanceUIModelEvent.MODEL, oldModel, AppearanceUIController.this.model);
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (AppearanceUIModel)pc.getCurrentWorkspace().getLookup().lookup(AppearanceUIModel.class);
            if (this.model == null) {
                AppearanceModel appearanceModel = this.appearanceController.getModel(pc.getCurrentWorkspace());
                this.model = new AppearanceUIModel(appearanceModel);
                pc.getCurrentWorkspace().add((Object)this.model);
                this.model.select();
            }
        }
        this.listeners = Collections.synchronizedSet(new HashSet());
        this.transformers = new HashMap<String, Map<TransformerCategory, Set<TransformerUI>>>();
        for (AppearanceModel ec : ELEMENT_CLASSES) {
            this.transformers.put((String)ec, new LinkedHashMap());
        }
        HashMap tMap = new HashMap();
        for (Transformer t : Lookup.getDefault().lookupAll(Transformer.class)) {
            tMap.put(t.getClass(), t);
        }
        for (TransformerUI ui : Lookup.getDefault().lookupAll(TransformerUI.class)) {
            Set uis;
            Transformer t = (Transformer)tMap.get(ui.getTransformerClass());
            if (t == null) continue;
            TransformerCategory c = ui.getCategory();
            if (t.isNode()) {
                uis = this.transformers.get(NODE_ELEMENT).computeIfAbsent(c, k -> new LinkedHashSet());
                uis.add(ui);
            }
            if (!t.isEdge()) continue;
            uis = this.transformers.get(EDGE_ELEMENT).computeIfAbsent(c, k -> new LinkedHashSet());
            uis.add(ui);
        }
    }

    public void transform(Function function) {
        if (this.model != null && function != null) {
            this.model.saveTransformerProperties();
            this.appearanceController.transform(function);
        }
    }

    public Collection<TransformerCategory> getCategories(String elementClass) {
        return this.transformers.get(elementClass).keySet();
    }

    public Collection<TransformerUI> getTransformerUIs(String elementClass, TransformerCategory category) {
        return this.transformers.get(elementClass).get(category);
    }

    public AppearanceUIModel getModel() {
        return this.model;
    }

    public AppearanceUIModel getModel(Workspace workspace) {
        AppearanceUIModel m = (AppearanceUIModel)workspace.getLookup().lookup(AppearanceUIModel.class);
        if (m == null) {
            AppearanceController ac = (AppearanceController)Lookup.getDefault().lookup(AppearanceController.class);
            AppearanceModel appearanceModel = ac.getModel(workspace);
            m = new AppearanceUIModel(appearanceModel);
            workspace.add((Object)m);
        }
        return m;
    }

    public void setSelectedElementClass(String elementClass) {
        String oldValue;
        if (!elementClass.equals(NODE_ELEMENT) && !elementClass.equals(EDGE_ELEMENT)) {
            throw new RuntimeException("Element class has to be nodes or edges");
        }
        if (this.model != null && !(oldValue = this.model.getSelectedElementClass()).equals(elementClass)) {
            this.model.setSelectedElementClass(elementClass);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_ELEMENT_CLASS, oldValue, elementClass);
        }
    }

    public void setSelectedCategory(TransformerCategory category) {
        TransformerCategory oldValue;
        if (this.model != null && !(oldValue = this.model.getSelectedCategory()).equals(category)) {
            this.model.setSelectedCategory(category);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_CATEGORY, oldValue, category);
        }
    }

    public void setSelectedTransformerUI(TransformerUI ui) {
        TransformerUI oldValue;
        if (this.model != null && !(oldValue = this.model.getSelectedTransformerUI()).equals(ui)) {
            this.model.setAutoApply(false);
            this.model.setSelectedTransformerUI(ui);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_TRANSFORMER_UI, oldValue, ui);
        }
    }

    public void setSelectedFunction(Function function) {
        Function oldValue;
        if (this.model != null && ((oldValue = this.model.getSelectedFunction()) == null && function != null || oldValue != null && function == null || function != null && oldValue != null && !oldValue.equals(function))) {
            this.model.setAutoApply(false);
            this.model.setSelectedFunction(function);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_FUNCTION, oldValue, function);
        }
    }

    public void setAutoApply(boolean autoApply) {
        if (this.model != null) {
            this.model.setAutoApply(autoApply);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SET_AUTO_APPLY, !autoApply, autoApply);
        }
    }

    public void startAutoApply() {
        AutoAppyTransformer aat;
        if (this.model != null && (aat = this.model.getAutoApplyTransformer()) != null) {
            aat.start();
            this.firePropertyChangeEvent(AppearanceUIModelEvent.START_STOP_AUTO_APPLY, false, true);
        }
    }

    public void stopAutoApply() {
        AutoAppyTransformer aat;
        if (this.model != null && (aat = this.model.getAutoApplyTransformer()) != null) {
            aat.stop();
            this.firePropertyChangeEvent(AppearanceUIModelEvent.START_STOP_AUTO_APPLY, true, false);
        }
    }

    public void refreshColumnsList() {
        if (this.model != null) {
            Function function = this.model.getSelectedFunction();
            if (function != null && !function.isValid()) {
                this.setSelectedFunction(null);
            }
            this.firePropertyChangeEvent(AppearanceUIModelEvent.ATTRIBUTE_LIST, null, null);
        }
    }

    public void refreshFunction() {
        if (this.model != null) {
            this.firePropertyChangeEvent(AppearanceUIModelEvent.REFRESH_FUNCTION, null, null);
        }
    }

    public AppearanceController getAppearanceController() {
        return this.appearanceController;
    }

    protected TransformerCategory getFirstCategory(String elementClass) {
        return this.transformers.get(elementClass).keySet().toArray(new TransformerCategory[0])[0];
    }

    protected TransformerUI getFirstTransformerUI(String elementClass, TransformerCategory category) {
        Map<TransformerCategory, Set<TransformerUI>> e = this.transformers.get(elementClass);
        return e.get(category).toArray(new TransformerUI[0])[0];
    }

    public void addPropertyChangeListener(AppearanceUIModelListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(AppearanceUIModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        AppearanceUIModelEvent event = new AppearanceUIModelEvent(this, propertyName, oldValue, newValue);
        for (AppearanceUIModelListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }
}

