/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.datalab.plugin.manipulators.GeneralColumnsChooser;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;

public class GeneralChooseColumnsUI
extends JPanel
implements ManipulatorUI {
    private GeneralColumnsChooser columnsChooser;
    private ColumnCheckBox[] columnsCheckBoxes;
    private JPanel contentPanel;
    private JScrollPane contentScrollPane;
    private JLabel descriptionLabel;

    public GeneralChooseColumnsUI(String descriptionText) {
        this.initComponents();
        this.descriptionLabel.setText(descriptionText);
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.columnsChooser = (GeneralColumnsChooser)m;
        this.refreshColumns();
    }

    public void unSetup() {
        this.columnsChooser.setColumns(this.getChosenColumns());
    }

    public String getDisplayName() {
        return this.columnsChooser.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    public Column[] getChosenColumns() {
        ArrayList<Column> columnsToClearDataList = new ArrayList<Column>();
        for (ColumnCheckBox c : this.columnsCheckBoxes) {
            if (!c.isSelected()) continue;
            columnsToClearDataList.add(c.getColumn());
        }
        return columnsToClearDataList.toArray(new Column[0]);
    }

    private void refreshColumns() {
        Column[] columns = this.columnsChooser.getColumns();
        this.columnsCheckBoxes = new ColumnCheckBox[columns.length];
        this.contentPanel.removeAll();
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        for (int i = 0; i < columns.length; ++i) {
            this.columnsCheckBoxes[i] = new ColumnCheckBox(columns[i], true);
            this.contentPanel.add((Component)this.columnsCheckBoxes[i].getCheckBox(), "wrap");
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void initComponents() {
        this.contentScrollPane = new JScrollPane();
        this.contentPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.contentPanel.setLayout(new GridLayout(1, 0));
        this.contentScrollPane.setViewportView(this.contentPanel);
        this.descriptionLabel.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING, -1, 319, Short.MAX_VALUE).addComponent(this.contentScrollPane, GroupLayout.Alignment.LEADING, -1, 319, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentScrollPane, -1, 220, Short.MAX_VALUE).addContainerGap()));
    }

    private static class ColumnCheckBox {
        private final JCheckBox checkBox;
        private final Column column;

        public ColumnCheckBox(Column column, boolean selected) {
            this.checkBox = new JCheckBox(column.getTitle(), selected);
            this.column = column;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public Column getColumn() {
            return this.column;
        }
    }
}

