/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse;

public class GetNetworkInsightsAccessScopeAnalysisFindingsIterable
implements SdkIterable<GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
    private final Ec2Client client;
    private final GetNetworkInsightsAccessScopeAnalysisFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetNetworkInsightsAccessScopeAnalysisFindingsIterable(Ec2Client client, GetNetworkInsightsAccessScopeAnalysisFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher();
    }

    public Iterator<GetNetworkInsightsAccessScopeAnalysisFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessScopeAnalysisFinding> analysisFindings() {
        Function<GetNetworkInsightsAccessScopeAnalysisFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisFindings() != null) {
                return response.analysisFindings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher
    implements SyncPageFetcher<GetNetworkInsightsAccessScopeAnalysisFindingsResponse> {
        private GetNetworkInsightsAccessScopeAnalysisFindingsResponseFetcher() {
        }

        public boolean hasNextPage(GetNetworkInsightsAccessScopeAnalysisFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetNetworkInsightsAccessScopeAnalysisFindingsResponse nextPage(GetNetworkInsightsAccessScopeAnalysisFindingsResponse previousPage) {
            if (previousPage == null) {
                return GetNetworkInsightsAccessScopeAnalysisFindingsIterable.this.client.getNetworkInsightsAccessScopeAnalysisFindings(GetNetworkInsightsAccessScopeAnalysisFindingsIterable.this.firstRequest);
            }
            return GetNetworkInsightsAccessScopeAnalysisFindingsIterable.this.client.getNetworkInsightsAccessScopeAnalysisFindings((GetNetworkInsightsAccessScopeAnalysisFindingsRequest)((Object)GetNetworkInsightsAccessScopeAnalysisFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

