/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.util.Arrays;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.TrustManager;
import org.ldaptive.AbstractConfig;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.HostnameVerifierConfig;

public class SslConfig
extends AbstractConfig {
    private CredentialConfig credentialConfig;
    private TrustManager[] trustManagers;
    private CertificateHostnameVerifier hostnameVerifier;
    private HostnameVerifierConfig hostnameVerifierConfig;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private HandshakeCompletedListener[] handshakeCompletedListeners;

    public SslConfig() {
    }

    public SslConfig(CredentialConfig config) {
        this.credentialConfig = config;
    }

    public SslConfig(TrustManager ... managers) {
        this.trustManagers = managers;
    }

    public SslConfig(CredentialConfig config, TrustManager ... managers) {
        this.credentialConfig = config;
        this.trustManagers = managers;
    }

    public boolean isEmpty() {
        return this.credentialConfig == null && this.trustManagers == null && this.hostnameVerifier == null && this.hostnameVerifierConfig == null && this.enabledCipherSuites == null && this.enabledProtocols == null && this.handshakeCompletedListeners == null;
    }

    public CredentialConfig getCredentialConfig() {
        return this.credentialConfig;
    }

    public void setCredentialConfig(CredentialConfig config) {
        this.checkImmutable();
        this.logger.trace("setting credentialConfig: {}", (Object)config);
        this.credentialConfig = config;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManager ... managers) {
        this.checkImmutable();
        this.logger.trace("setting trustManagers: {}", (Object)Arrays.toString(managers));
        this.trustManagers = managers;
    }

    public CertificateHostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(CertificateHostnameVerifier verifier) {
        this.checkImmutable();
        this.logger.trace("setting hostnameVerifier: {}", (Object)verifier);
        this.hostnameVerifier = verifier;
    }

    protected HostnameVerifierConfig getHostnameVerifierConfig() {
        return this.hostnameVerifierConfig;
    }

    protected void setHostnameVerifierConfig(HostnameVerifierConfig config) {
        this.checkImmutable();
        this.logger.trace("setting hostnameVerifierConfig: {}", (Object)config);
        this.hostnameVerifierConfig = config;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String ... suites) {
        this.checkImmutable();
        this.logger.trace("setting enabledCipherSuites: {}", (Object)Arrays.toString(suites));
        this.enabledCipherSuites = suites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String ... protocols) {
        this.checkImmutable();
        this.logger.trace("setting enabledProtocols: {}", (Object)Arrays.toString(protocols));
        this.enabledProtocols = protocols;
    }

    public HandshakeCompletedListener[] getHandshakeCompletedListeners() {
        return this.handshakeCompletedListeners;
    }

    public void setHandshakeCompletedListeners(HandshakeCompletedListener ... listeners) {
        this.checkImmutable();
        this.logger.trace("setting handshakeCompletedListeners: {}", (Object)Arrays.toString(this.handshakeCompletedListeners));
        this.handshakeCompletedListeners = listeners;
    }

    public static SslConfig newSslConfig(SslConfig config) {
        SslConfig sc = new SslConfig();
        sc.setCredentialConfig(config.getCredentialConfig());
        sc.setTrustManagers(config.getTrustManagers());
        sc.setHostnameVerifier(config.getHostnameVerifier());
        sc.setHostnameVerifierConfig(config.getHostnameVerifierConfig());
        sc.setEnabledCipherSuites(config.getEnabledCipherSuites());
        sc.setEnabledProtocols(config.getEnabledProtocols());
        sc.setHandshakeCompletedListeners(config.getHandshakeCompletedListeners());
        return sc;
    }

    public String toString() {
        return String.format("[%s@%d::credentialConfig=%s, trustManagers=%s, hostnameVerifier=%s, hostnameVerifierConfig=%s, enabledCipherSuites=%s, enabledProtocols=%s, handshakeCompletedListeners=%s]", this.getClass().getName(), this.hashCode(), this.credentialConfig, Arrays.toString(this.trustManagers), this.hostnameVerifier, this.hostnameVerifierConfig, Arrays.toString(this.enabledCipherSuites), Arrays.toString(this.enabledProtocols), Arrays.toString(this.handshakeCompletedListeners));
    }
}

