sap.ui.define([
	"sap/ui/model/json/JSONModel",
	'sap/ui/core/mvc/Controller',
	'sap/ui/webc/fiori/illustrations/BeforeSearch',
	'sap/ui/webc/fiori/illustrations/NoActivities',
	'sap/ui/webc/fiori/illustrations/NoData',
	'sap/ui/webc/fiori/illustrations/NoMail',
	'sap/ui/webc/fiori/illustrations/NoMail_v1',
	'sap/ui/webc/fiori/illustrations/NoEntries',
	'sap/ui/webc/fiori/illustrations/NoNotifications',
	'sap/ui/webc/fiori/illustrations/NoSavedItems',
	'sap/ui/webc/fiori/illustrations/NoSavedItems_v1',
	'sap/ui/webc/fiori/illustrations/NoSearchResults',
	'sap/ui/webc/fiori/illustrations/NoTasks',
	'sap/ui/webc/fiori/illustrations/NoTasks_v1',
	'sap/ui/webc/fiori/illustrations/UnableToLoad',
	'sap/ui/webc/fiori/illustrations/UnableToLoadImage',
	'sap/ui/webc/fiori/illustrations/UnableToUpload',
	'sap/ui/webc/fiori/illustrations/AddColumn',
	'sap/ui/webc/fiori/illustrations/AddPeople',
	'sap/ui/webc/fiori/illustrations/BalloonSky',
	'sap/ui/webc/fiori/illustrations/Connection',
	'sap/ui/webc/fiori/illustrations/EmptyCalendar',
	'sap/ui/webc/fiori/illustrations/EmptyList',
	'sap/ui/webc/fiori/illustrations/EmptyPlanningCalendar',
	'sap/ui/webc/fiori/illustrations/ErrorScreen',
	'sap/ui/webc/fiori/illustrations/FilterTable',
	'sap/ui/webc/fiori/illustrations/GroupTable',
	'sap/ui/webc/fiori/illustrations/NoFilterResults',
	'sap/ui/webc/fiori/illustrations/PageNotFound',
	'sap/ui/webc/fiori/illustrations/ReloadScreen',
	'sap/ui/webc/fiori/illustrations/ResizeColumn',
	'sap/ui/webc/fiori/illustrations/SearchEarth',
	'sap/ui/webc/fiori/illustrations/SearchFolder',
	'sap/ui/webc/fiori/illustrations/SimpleBalloon',
	'sap/ui/webc/fiori/illustrations/SimpleBell',
	'sap/ui/webc/fiori/illustrations/SimpleCalendar',
	'sap/ui/webc/fiori/illustrations/SimpleCheckMark',
	'sap/ui/webc/fiori/illustrations/SimpleConnection',
	'sap/ui/webc/fiori/illustrations/SimpleEmptyDoc',
	'sap/ui/webc/fiori/illustrations/SimpleEmptyList',
	'sap/ui/webc/fiori/illustrations/SimpleError',
	'sap/ui/webc/fiori/illustrations/SimpleMagnifier',
	'sap/ui/webc/fiori/illustrations/SimpleMail',
	'sap/ui/webc/fiori/illustrations/SimpleNoSavedItems',
	'sap/ui/webc/fiori/illustrations/SimpleNotFoundMagnifier',
	'sap/ui/webc/fiori/illustrations/SimpleReload',
	'sap/ui/webc/fiori/illustrations/SimpleTask',
	'sap/ui/webc/fiori/illustrations/SleepingBell',
	'sap/ui/webc/fiori/illustrations/SortColumn',
	'sap/ui/webc/fiori/illustrations/SuccessBalloon',
	'sap/ui/webc/fiori/illustrations/SuccessCheckMark',
	'sap/ui/webc/fiori/illustrations/SuccessHighFive',
	'sap/ui/webc/fiori/illustrations/SuccessScreen',
	'sap/ui/webc/fiori/illustrations/Tent',
	'sap/ui/webc/fiori/illustrations/UploadCollection',
	'sap/ui/webc/fiori/illustrations/tnt/ChartArea',
	'sap/ui/webc/fiori/illustrations/tnt/ChartArea2',
	'sap/ui/webc/fiori/illustrations/tnt/ChartBar',
	'sap/ui/webc/fiori/illustrations/tnt/ChartBPMNFlow',
	'sap/ui/webc/fiori/illustrations/tnt/ChartBullet',
	'sap/ui/webc/fiori/illustrations/tnt/ChartDoughnut',
	'sap/ui/webc/fiori/illustrations/tnt/ChartFlow',
	'sap/ui/webc/fiori/illustrations/tnt/ChartGantt',
	'sap/ui/webc/fiori/illustrations/tnt/ChartOrg',
	'sap/ui/webc/fiori/illustrations/tnt/ChartPie',
	'sap/ui/webc/fiori/illustrations/tnt/CodePlaceholder',
	'sap/ui/webc/fiori/illustrations/tnt/Company',
	'sap/ui/webc/fiori/illustrations/tnt/Components',
	'sap/ui/webc/fiori/illustrations/tnt/ExternalLink',
	'sap/ui/webc/fiori/illustrations/tnt/FaceID',
	'sap/ui/webc/fiori/illustrations/tnt/Fingerprint',
	'sap/ui/webc/fiori/illustrations/tnt/Lock',
	'sap/ui/webc/fiori/illustrations/tnt/Mission',
	'sap/ui/webc/fiori/illustrations/tnt/NoApplications',
	'sap/ui/webc/fiori/illustrations/tnt/NoFlows',
	'sap/ui/webc/fiori/illustrations/tnt/NoUsers',
	'sap/ui/webc/fiori/illustrations/tnt/Radar',
	'sap/ui/webc/fiori/illustrations/tnt/Secrets',
	'sap/ui/webc/fiori/illustrations/tnt/Services',
	'sap/ui/webc/fiori/illustrations/tnt/SessionExpired',
	'sap/ui/webc/fiori/illustrations/tnt/SessionExpiring',
	'sap/ui/webc/fiori/illustrations/tnt/Success',
	'sap/ui/webc/fiori/illustrations/tnt/SuccessfulAuth',
	'sap/ui/webc/fiori/illustrations/tnt/Systems',
	'sap/ui/webc/fiori/illustrations/tnt/Teams',
	'sap/ui/webc/fiori/illustrations/tnt/Tools',
	'sap/ui/webc/fiori/illustrations/tnt/UnableToLoad',
	'sap/ui/webc/fiori/illustrations/tnt/Unlock',
	'sap/ui/webc/fiori/illustrations/tnt/UnsuccessfulAuth',
	'sap/ui/webc/fiori/illustrations/tnt/User2'
],
	function (JSONModel, Controller) {
		"use strict";

		return Controller.extend("sap.ui.webc.fiori.sample.IllustratedMessage.C", {

			onInit: function () {

				var aIMITypeData = [
					{key: "BeforeSearch"},
					{key: "NoActivities"},
					{key: "NoData"},
					{key: "NoMail"},
					{key: "NoMail_v1"},
					{key: "NoEntries"},
					{key: "NoNotifications"},
					{key: "NoSavedItems"},
					{key: "NoSavedItems_v1"},
					{key: "NoSearchResults"},
					{key: "NoTasks"},
					{key: "NoTasks_v1"},
					{key: "UnableToLoad"},
					{key: "UnableToLoadImage"},
					{key: "UnableToUpload"},
					{key: "AddColumn"},
					{key: "AddPeople"},
					{key: "BalloonSky"},
					{key: "Connection"},
					{key: "EmptyCalendar"},
					{key: "EmptyList"},
					{key: "EmptyPlanningCalendar"},
					{key: "ErrorScreen"},
					{key: "FilterTable"},
					{key: "GroupTable"},
					{key: "NoFilterResults"},
					{key: "PageNotFound"},
					{key: "ReloadScreen"},
					{key: "ResizeColumn"},
					{key: "SearchEarth"},
					{key: "SearchFolder"},
					{key: "SimpleBalloon"},
					{key: "SimpleBell"},
					{key: "SimpleCalendar"},
					{key: "SimpleCheckMark"},
					{key: "SimpleConnection"},
					{key: "SimpleEmptyDoc"},
					{key: "SimpleEmptyList"},
					{key: "SimpleError"},
					{key: "SimpleMagnifier"},
					{key: "SimpleMail"},
					{key: "SimpleNoSavedItems"},
					{key: "SimpleNotFoundMagnifier"},
					{key: "SimpleReload"},
					{key: "SimpleTask"},
					{key: "SleepingBell"},
					{key: "SortColumn"},
					{key: "SuccessBalloon"},
					{key: "SuccessCheckMark"},
					{key: "SuccessHighFive"},
					{key: "SuccessScreen"},
					{key: "Tent"},
					{key: "UploadCollection"},
					{key: "TntChartArea"},
					{key: "TntChartArea2"},
					{key: "TntChartBar"},
					{key: "TntChartBPMNFlow"},
					{key: "TntChartBullet"},
					{key: "TntChartDoughnut"},
					{key: "TntChartFlow"},
					{key: "TntChartGantt"},
					{key: "TntChartOrg"},
					{key: "TntChartPie"},
					{key: "TntCodePlaceholder"},
					{key: "TntCompany"},
					{key: "TntComponents"},
					{key: "TntExternalLink"},
					{key: "TntFaceID"},
					{key: "TntFingerprint"},
					{key: "TntLock"},
					{key: "TntMission"},
					{key: "TntNoApplications"},
					{key: "TntNoFlows"},
					{key: "TntNoUsers"},
					{key: "TntRadar"},
					{key: "TntSecrets"},
					{key: "TntServices"},
					{key: "TntSessionExpired"},
					{key: "TntSessionExpiring"},
					{key: "TntSuccess"},
					{key: "TntSuccessfulAuth"},
					{key: "TntSystems"},
					{key: "TntTeams"},
					{key: "TntTools"},
					{key: "TntUnableToLoad"},
					{key: "TntUnlock"},
					{key: "TntUnsuccessfulAuth"},
					{key: "TntUser2"}
				];

				this.oModel = new JSONModel({
					typeTypes: aIMITypeData
				});

				this.oModel.setProperty("/sSelectedType", aIMITypeData[0].key);

				this.getView().setModel(this.oModel);
			},
			onSelectType: function (oEvent) {
				this.oModel.setProperty("/sSelectedType", oEvent.getParameter("selectedItem").getKey());
			}
		});

	});
