/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.xml.ForEachTag;
import org.apache.taglibs.standard.tag.common.xml.JSTLNodeList;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathConstants;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathNamespaceContext;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtil {
    private static final String PAGE_NS_URL = "http://java.sun.com/jstl/xpath/page";
    private static final String REQUEST_NS_URL = "http://java.sun.com/jstl/xpath/request";
    private static final String SESSION_NS_URL = "http://java.sun.com/jstl/xpath/session";
    private static final String APP_NS_URL = "http://java.sun.com/jstl/xpath/app";
    private static final String PARAM_NS_URL = "http://java.sun.com/jstl/xpath/param";
    private static final String INITPARAM_NS_URL = "http://java.sun.com/jstl/xpath/initParam";
    private static final String COOKIE_NS_URL = "http://java.sun.com/jstl/xpath/cookie";
    private static final String HEADER_NS_URL = "http://java.sun.com/jstl/xpath/header";
    private PageContext pageContext;
    private static final String XPATH_FACTORY_CLASS_NAME = "org.apache.taglibs.standard.tag.common.xml.JSTLXPathFactory";
    private static XPathFactory XPATH_FACTORY;
    private static JSTLXPathNamespaceContext jstlXPathNamespaceContext;
    private static DocumentBuilderFactory dbf;

    public XPathUtil(PageContext pc) {
        this.pageContext = pc;
    }

    private static void initXPathFactory() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom", XPathUtil.XPATH_FACTORY_CLASS_NAME);
                    return null;
                }
            });
        } else {
            System.setProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom", XPATH_FACTORY_CLASS_NAME);
        }
        try {
            XPATH_FACTORY = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (XPathFactoryConfigurationException xpce) {
            xpce.printStackTrace();
        }
    }

    private static void initXPathNamespaceContext() {
        jstlXPathNamespaceContext = new JSTLXPathNamespaceContext();
        jstlXPathNamespaceContext.addNamespace("pageScope", PAGE_NS_URL);
        jstlXPathNamespaceContext.addNamespace("requestScope", REQUEST_NS_URL);
        jstlXPathNamespaceContext.addNamespace("sessionScope", SESSION_NS_URL);
        jstlXPathNamespaceContext.addNamespace("applicationScope", APP_NS_URL);
        jstlXPathNamespaceContext.addNamespace("param", PARAM_NS_URL);
        jstlXPathNamespaceContext.addNamespace("initParam", INITPARAM_NS_URL);
        jstlXPathNamespaceContext.addNamespace("header", HEADER_NS_URL);
        jstlXPathNamespaceContext.addNamespace("cookie", COOKIE_NS_URL);
    }

    private static void initDocumentBuilderFactory() {
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
    }

    private static Document newEmptyDocument() {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError();
        }
    }

    public String valueOf(Node contextNode, String xpathString) throws JspTagException {
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(jstlXPathNamespaceContext);
        xpath.setXPathVariableResolver(jxvr);
        try {
            return xpath.evaluate(xpathString, contextNode);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public boolean booleanValueOf(Node contextNode, String xpathString) throws JspTagException {
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(jstlXPathNamespaceContext);
        xpath.setXPathVariableResolver(jxvr);
        try {
            return (Boolean)xpath.evaluate(xpathString, contextNode, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(Resources.getMessage("XPATH_ERROR_XOBJECT", ex.toString()), ex);
        }
    }

    public List selectNodes(Node contextNode, String xpathString) throws JspTagException {
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(jstlXPathNamespaceContext);
            xpath.setXPathVariableResolver(jxvr);
            Object nl = xpath.evaluate(xpathString, contextNode, JSTLXPathConstants.OBJECT);
            return new JSTLNodeList(nl);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public Node selectSingleNode(Node contextNode, String xpathString) throws JspTagException {
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(jstlXPathNamespaceContext);
            xpath.setXPathVariableResolver(jxvr);
            return (Node)xpath.evaluate(xpathString, contextNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public static Node getContext(Tag t) throws JspTagException {
        ForEachTag xt = (ForEachTag)TagSupport.findAncestorWithClass(t, ForEachTag.class);
        if (xt == null) {
            return XPathUtil.newEmptyDocument();
        }
        return xt.getContext();
    }

    private static void p(String s) {
        System.out.println("[XPathUtil] " + s);
    }

    public static void printDetails(Node n) {
        XPathUtil.p("\n\nDetails of Node = > " + n);
        XPathUtil.p("Name:Type:Node Value = > " + n.getNodeName() + ":" + n.getNodeType() + ":" + n.getNodeValue());
        XPathUtil.p("Namespace URI : Prefix : localName = > " + n.getNamespaceURI() + ":" + n.getPrefix() + ":" + n.getLocalName());
        XPathUtil.p("\n Node has children => " + n.hasChildNodes());
        if (n.hasChildNodes()) {
            NodeList nl = n.getChildNodes();
            XPathUtil.p("Number of Children => " + nl.getLength());
            for (int i = 0; i < nl.getLength(); ++i) {
                Node childNode = nl.item(i);
                XPathUtil.printDetails(childNode);
            }
        }
    }

    static {
        jstlXPathNamespaceContext = null;
        dbf = null;
        XPathUtil.initXPathFactory();
        XPathUtil.initXPathNamespaceContext();
        XPathUtil.initDocumentBuilderFactory();
    }
}

