/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BytecodeConstant;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class InlinedBytecodeExpression
extends Expression {
    public static final Role<Expression> OPERAND_ROLE = new Role<Expression>("Operand", Expression.class, Expression.NULL);
    public static final InlinedBytecodeExpression NULL = new NullInlinedBytecodeExpression();
    private final AstCode _code;

    public InlinedBytecodeExpression(int offset, AstCode code, Object ... operands) {
        super(offset);
        this._code = VerifyArgument.notNull(code, "code");
        if (ArrayUtilities.isNullOrEmpty(operands) || operands.length == 1 && operands[0] == null) {
            return;
        }
        AstNodeCollection<Expression> operandNodes = this.getOperands();
        for (Object operand : operands) {
            if (operand != null) {
                operandNodes.add(operand instanceof Expression ? (Expression)operand : new BytecodeConstant(operand));
                continue;
            }
            operandNodes.add(BytecodeConstant.NULL);
        }
    }

    public InlinedBytecodeExpression(AstCode code, Object ... operands) {
        this(-34, code, operands);
    }

    public final AstCode getCode() {
        return this._code;
    }

    public final AstNodeCollection<Expression> getOperands() {
        return this.getChildrenByRole(OPERAND_ROLE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitInlinedBytecode(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof InlinedBytecodeExpression) {
            InlinedBytecodeExpression otherCode = (InlinedBytecodeExpression)other;
            return !otherCode.isNull() && this.getCode() == otherCode.getCode() && this.getOperands().matches(otherCode.getOperands(), match);
        }
        return false;
    }

    private static final class NullInlinedBytecodeExpression
    extends InlinedBytecodeExpression {
        public NullInlinedBytecodeExpression() {
            super(AstCode.Nop, new Object[0]);
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

