/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class SwitchSection
extends AstNode {
    public static final Role<CaseLabel> CASE_LABEL_ROLE = new Role<CaseLabel>("CaseLabel", CaseLabel.class);

    public final AstNodeCollection<Statement> getStatements() {
        return this.getChildrenByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final AstNodeCollection<CaseLabel> getCaseLabels() {
        return this.getChildrenByRole(CASE_LABEL_ROLE);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSwitchSection(this, data);
    }

    public Role<? extends SwitchSection> getRole() {
        return super.getRole();
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof SwitchSection) {
            SwitchSection otherSection = (SwitchSection)other;
            return !otherSection.isNull() && this.getCaseLabels().matches(otherSection.getCaseLabels(), match) && this.getStatements().matches(otherSection.getStatements(), match);
        }
        return false;
    }
}

