/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LocalClassHelper;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RewriteLocalClassesTransform
extends ContextTrackingVisitor<Void> {
    private final Map<TypeReference, TypeDeclaration> _localTypes = new LinkedHashMap<TypeReference, TypeDeclaration>();
    private final Map<TypeReference, List<ObjectCreationExpression>> _instantiations = new LinkedHashMap<TypeReference, List<ObjectCreationExpression>>();

    public RewriteLocalClassesTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        PhaseOneVisitor phaseOneVisitor = new PhaseOneVisitor(this.context);
        compilationUnit.acceptVisitor(phaseOneVisitor, null);
        super.run(compilationUnit);
        for (TypeReference localType : this._localTypes.keySet()) {
            TypeDeclaration declaration = this._localTypes.get(localType);
            List<ObjectCreationExpression> instantiations = this._instantiations.get(localType);
            LocalClassHelper.replaceClosureMembers(this.context, declaration, instantiations != null ? instantiations : Collections.emptyList());
        }
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, Void p) {
        TypeDefinition resolvedType;
        super.visitObjectCreationExpression(node, p);
        TypeReference type = node.getType().getUserData(Keys.TYPE_REFERENCE);
        TypeDefinition typeDefinition = resolvedType = type != null ? type.resolve() : null;
        if (resolvedType != null && RewriteLocalClassesTransform.isLocalOrAnonymous(resolvedType) && !resolvedType.isEquivalentTo(this.context.getCurrentType())) {
            List<ObjectCreationExpression> instantiations = this._instantiations.get(type);
            if (instantiations == null) {
                instantiations = new ArrayList<ObjectCreationExpression>();
                this._instantiations.put(type, instantiations);
            }
            instantiations.add(node);
        }
        return null;
    }

    private static boolean isLocalOrAnonymous(TypeDefinition type) {
        if (type == null) {
            return false;
        }
        return type.isLocalClass() || type.isAnonymous();
    }

    @Override
    public Void visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void p) {
        super.visitAnonymousObjectCreationExpression(node, p);
        TypeDefinition resolvedType = node.getTypeDeclaration().getUserData(Keys.TYPE_DEFINITION);
        if (resolvedType != null && RewriteLocalClassesTransform.isLocalOrAnonymous(resolvedType)) {
            List<ObjectCreationExpression> instantiations = this._instantiations.get(resolvedType);
            if (instantiations == null) {
                instantiations = new ArrayList<ObjectCreationExpression>();
                this._instantiations.put(resolvedType, instantiations);
            }
            instantiations.add(node);
        }
        return null;
    }

    private final class PhaseOneVisitor
    extends ContextTrackingVisitor<Void> {
        protected PhaseOneVisitor(DecompilerContext context) {
            super(context);
        }

        @Override
        protected Void visitTypeDeclarationOverride(TypeDeclaration typeDeclaration, Void p) {
            TypeDefinition type = typeDeclaration.getUserData(Keys.TYPE_DEFINITION);
            if (type != null && (RewriteLocalClassesTransform.isLocalOrAnonymous(type) || type.isAnonymous())) {
                RewriteLocalClassesTransform.this._localTypes.put(type, typeDeclaration);
            }
            return (Void)super.visitTypeDeclarationOverride(typeDeclaration, p);
        }
    }
}

