/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tomcat.websocket.server.WsContextListener;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsSessionListener;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class WsSci
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> set, ServletContext servletContext) throws ServletException {
        Object object;
        Object object2;
        WsServerContainer wsServerContainer = WsSci.init(servletContext, true);
        if (set == null || set.isEmpty()) {
            return;
        }
        HashSet<ServerApplicationConfig> hashSet = new HashSet<ServerApplicationConfig>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet hashSet3 = new HashSet();
        try {
            object2 = ContainerProvider.class.getName();
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46) + 1);
            for (Class<?> object3 : set) {
                int n = object3.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isInterface(n) || !WsSci.isExported(object3) || object3.getName().startsWith((String)object2)) continue;
                if (ServerApplicationConfig.class.isAssignableFrom(object3)) {
                    hashSet.add((ServerApplicationConfig)object3.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                if (Endpoint.class.isAssignableFrom(object3)) {
                    object = object3;
                    hashSet2.add(object);
                }
                if (!object3.isAnnotationPresent(ServerEndpoint.class)) continue;
                hashSet3.add(object3);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ServletException((Throwable)reflectiveOperationException);
        }
        object2 = new HashSet();
        HashSet hashSet4 = new HashSet();
        if (hashSet.isEmpty()) {
            hashSet4.addAll(hashSet3);
        } else {
            for (ServerApplicationConfig serverApplicationConfig : hashSet) {
                Set set2;
                object = serverApplicationConfig.getEndpointConfigs(hashSet2);
                if (object != null) {
                    object2.addAll(object);
                }
                if ((set2 = serverApplicationConfig.getAnnotatedEndpointClasses(hashSet3)) == null) continue;
                hashSet4.addAll(set2);
            }
        }
        try {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)iterator.next();
                wsServerContainer.addEndpoint(serverEndpointConfig);
            }
            Iterator iterator2 = hashSet4.iterator();
            while (iterator2.hasNext()) {
                Class clazz = (Class)iterator2.next();
                wsServerContainer.addEndpoint(clazz, true);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new ServletException((Throwable)deploymentException);
        }
    }

    private static boolean isExported(Class<?> clazz) {
        String string = clazz.getPackage().getName();
        Module module = clazz.getModule();
        return module.isExported(string);
    }

    static WsServerContainer init(ServletContext servletContext, boolean bl) {
        WsServerContainer wsServerContainer = new WsServerContainer(servletContext);
        servletContext.setAttribute("jakarta.websocket.server.ServerContainer", (Object)wsServerContainer);
        servletContext.addListener((EventListener)((Object)new WsSessionListener(wsServerContainer)));
        if (bl) {
            servletContext.addListener((EventListener)((Object)new WsContextListener()));
        }
        return wsServerContainer;
    }
}

