/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.ui.LiveResultsPanel;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.CPUSelectionHandler;
import org.graalvm.visualvm.lib.ui.cpu.LiveFlatProfileCollectorPanel;
import org.graalvm.visualvm.lib.ui.cpu.statistics.StatisticalModule;

public class LiveFlatProfilePanel
extends JPanel
implements LiveResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.cpu.Bundle");
    private static final String NO_RESULTS_STRING = messages.getString("LiveFlatProfilePanel_NoResultsString");
    private CPUResUserActionsHandler actionsHandler = null;
    private Collection statModules = null;
    private CPUSelectionHandler handler = new CPUSelectionHandler(){

        @Override
        public void methodSelected(int threadId, int methodId, int view) {
            Iterator it = LiveFlatProfilePanel.this.statModules.iterator();
            while (it.hasNext()) {
                ((StatisticalModule)it.next()).setSelectedMethodId(methodId);
            }
        }
    };
    private JPanel noResultsPanel = null;
    private JPanel resultsTable = null;
    private LiveFlatProfileCollectorPanel fpCollectorPanel = null;
    private TargetAppRunner runner;

    public LiveFlatProfilePanel(TargetAppRunner runner, CPUResUserActionsHandler actionsHandler, Collection additionalStats, boolean sampling) {
        this.actionsHandler = actionsHandler;
        this.runner = runner;
        this.statModules = additionalStats;
        this.initComponents();
        this.setupFlatCollector(sampling);
    }

    public LiveFlatProfilePanel(TargetAppRunner runner, CPUResUserActionsHandler actionsHandler, boolean sampling) {
        this(runner, actionsHandler, Collections.EMPTY_LIST, sampling);
    }

    public void setAdditionalStats(Collection<StatisticalModule> stats) {
        this.statModules = stats;
    }

    @Override
    public int getSortingColumn() {
        return this.fpCollectorPanel.getSortingColumn();
    }

    @Override
    public boolean getSortingOrder() {
        return this.fpCollectorPanel.getSortingOrder();
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        return this.fpCollectorPanel.getViewImage(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        return this.fpCollectorPanel.getViewName();
    }

    @Override
    public boolean fitsVisibleArea() {
        return this.fpCollectorPanel.fitsVisibleArea();
    }

    @Override
    public void handleRemove() {
        this.fpCollectorPanel.handleRemove();
    }

    @Override
    public void handleShutdown() {
        this.handleRemove();
        this.fpCollectorPanel.handleShutdown();
    }

    public boolean hasValidDrillDown() {
        return false;
    }

    @Override
    public boolean hasView() {
        return this.fpCollectorPanel.hasView();
    }

    @Override
    public void reset() {
        this.fpCollectorPanel.reset();
    }

    @Override
    public boolean supports(int instrumentationType) {
        return this.fpCollectorPanel.supports(instrumentationType);
    }

    @Override
    public void updateLiveResults() {
        this.fpCollectorPanel.updateLiveResults();
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        this.fpCollectorPanel.exportData(exportedFileType, eDD, viewName);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.noResultsPanel = new JPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noResultsLabel = new JLabel(NO_RESULTS_STRING);
        noResultsLabel.setFont(noResultsLabel.getFont().deriveFont(14));
        noResultsLabel.setEnabled(false);
        this.noResultsPanel.add((Component)noResultsLabel, "North");
        this.resultsTable = new JPanel(new CardLayout());
        this.resultsTable.add((Component)noResultsLabel, "NORESULTS");
        this.add((Component)this.resultsTable, "Center");
    }

    private void setupFlatCollector(boolean sampling) {
        this.fpCollectorPanel = new LiveFlatProfileCollectorPanel(this.runner, this.actionsHandler, this.handler, sampling);
        this.resultsTable.add((Component)this.fpCollectorPanel, "RESULTS");
        ((CardLayout)this.resultsTable.getLayout()).show(this.resultsTable, "RESULTS");
    }
}

