/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CompressBatch;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.Instrumentation.InvocationObserver;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.UnknownException;
import com.zeroc.IceInternal.BatchRequestQueue;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.InvocationFutureI;
import com.zeroc.IceInternal.ObserverHelper;
import com.zeroc.IceInternal.OutgoingAsyncBaseI;
import com.zeroc.IceInternal.RetryException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class CommunicatorFlushBatch
extends InvocationFutureI<Void> {
    private int _useCount = 1;

    public CommunicatorFlushBatch(Communicator communicator, Instance instance) {
        super(communicator, instance, "flushBatchRequests");
    }

    @Override
    protected void markCompleted() {
        this.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushConnection(final ConnectionI con, final CompressBatch compressBatch) {
        CommunicatorFlushBatch communicatorFlushBatch = this;
        synchronized (communicatorFlushBatch) {
            ++this._useCount;
        }
        try {
            class FlushBatch
            extends OutgoingAsyncBaseI<Void> {
                public FlushBatch() {
                    super(CommunicatorFlushBatch.this.getCommunicator(), CommunicatorFlushBatch.this._instance, CommunicatorFlushBatch.this.getOperation());
                }

                @Override
                protected void markCompleted() {
                    assert (false);
                }

                @Override
                public boolean sent() {
                    if (this._childObserver != null) {
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    CommunicatorFlushBatch.this.doCheck(false);
                    return false;
                }

                @Override
                public boolean completed(Exception ex) {
                    if (this._childObserver != null) {
                        this._childObserver.failed(ex.ice_id());
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    CommunicatorFlushBatch.this.doCheck(false);
                    return false;
                }

                @Override
                protected InvocationObserver getObserver() {
                    return CommunicatorFlushBatch.this._observer;
                }
            }
            final FlushBatch flushBatch = new FlushBatch();
            final BatchRequestQueue.SwapResult r = con.getBatchRequestQueue().swap(flushBatch.getOs());
            if (r == null) {
                flushBatch.sent();
            } else if (this._instance.queueRequests()) {
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){
                    {
                    }

                    @Override
                    public Void call() throws RetryException {
                        boolean comp = false;
                        comp = compressBatch == CompressBatch.Yes ? true : (compressBatch == CompressBatch.No ? false : r.compress);
                        con.sendAsyncRequest(flushBatch, comp, false, r.batchRequestNum);
                        return null;
                    }
                });
            } else {
                boolean comp = false;
                comp = compressBatch == CompressBatch.Yes ? true : (compressBatch == CompressBatch.No ? false : r.compress);
                con.sendAsyncRequest(flushBatch, comp, false, r.batchRequestNum);
            }
        }
        catch (RetryException ex) {
            this.doCheck(false);
            throw ex.get();
        }
        catch (LocalException ex) {
            this.doCheck(false);
            throw ex;
        }
    }

    public void invoke(CompressBatch compressBatch) {
        this._observer = ObserverHelper.get(this._instance, "flushBatchRequests");
        this._instance.outgoingConnectionFactory().flushAsyncBatchRequests(compressBatch, this);
        this._instance.objectAdapterFactory().flushAsyncBatchRequests(compressBatch, this);
        this.doCheck(true);
    }

    public void waitForResponse() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        try {
            this.get();
        }
        catch (InterruptedException ex) {
            throw new OperationInterruptedException();
        }
        catch (ExecutionException ee) {
            try {
                throw ee.getCause().fillInStackTrace();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UnknownException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheck(boolean userThread) {
        CommunicatorFlushBatch communicatorFlushBatch = this;
        synchronized (communicatorFlushBatch) {
            assert (this._useCount > 0);
            if (--this._useCount > 0) {
                return;
            }
        }
        if (this.sent(true)) {
            if (userThread) {
                this._sentSynchronously = true;
                this.invokeSent();
            } else {
                this.invokeSentAsync();
            }
        }
    }
}

