/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.UsageMarker;

public class ShortestUsageMarker
extends UsageMarker {
    private static final ShortestUsageMark INITIAL_MARK = new ShortestUsageMark("is kept by a directive in the configuration.\n\n");
    private ShortestUsageMark currentUsageMark = INITIAL_MARK;
    private final MyRecursiveCauseChecker recursiveCauseChecker = new MyRecursiveCauseChecker();

    @Override
    protected void markProgramClassBody(ProgramClass programClass) {
        ShortestUsageMark previousUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(programClass), "is extended by   ", 10000, programClass);
        super.markProgramClassBody(programClass);
        this.currentUsageMark = previousUsageMark;
    }

    @Override
    protected void markProgramFieldBody(ProgramClass programClass, ProgramField programField) {
        ShortestUsageMark previousUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(programField), "is referenced by ", 1, programClass, programField);
        super.markProgramFieldBody(programClass, programField);
        this.currentUsageMark = previousUsageMark;
    }

    @Override
    protected void markProgramMethodBody(ProgramClass programClass, ProgramMethod programMethod) {
        ShortestUsageMark previousUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(programMethod), "is invoked by    ", 1, programClass, programMethod);
        super.markProgramMethodBody(programClass, programMethod);
        this.currentUsageMark = previousUsageMark;
    }

    @Override
    protected void markMethodHierarchy(Clazz clazz, Method method) {
        ShortestUsageMark previousUsageMark = this.currentUsageMark;
        this.currentUsageMark = new ShortestUsageMark(this.getShortestUsageMark(method), "implements       ", 100, clazz, method);
        super.markMethodHierarchy(clazz, method);
        this.currentUsageMark = previousUsageMark;
    }

    @Override
    protected void markAsUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        ShortestUsageMark shortestUsageMark = visitorInfo != null && visitorInfo instanceof ShortestUsageMark && !((ShortestUsageMark)visitorInfo).isCertain() && !this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo) ? new ShortestUsageMark((ShortestUsageMark)visitorInfo, true) : this.currentUsageMark;
        visitorAccepter.setVisitorInfo(shortestUsageMark);
    }

    @Override
    protected boolean shouldBeMarkedAsUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)visitorInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo);
    }

    @Override
    protected boolean isUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo != null && visitorInfo instanceof ShortestUsageMark && ((ShortestUsageMark)visitorInfo).isCertain();
    }

    @Override
    protected void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(new ShortestUsageMark(this.currentUsageMark, false));
    }

    @Override
    protected boolean shouldBeMarkedAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)visitorInfo).isCertain() && this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo);
    }

    @Override
    protected boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo != null && visitorInfo instanceof ShortestUsageMark && !((ShortestUsageMark)visitorInfo).isCertain();
    }

    protected ShortestUsageMark getShortestUsageMark(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return (ShortestUsageMark)visitorInfo;
    }

    private boolean isCausedBy(ShortestUsageMark shortestUsageMark, Clazz clazz) {
        return this.recursiveCauseChecker.check(shortestUsageMark, clazz);
    }

    private class MyRecursiveCauseChecker
    implements ClassVisitor,
    MemberVisitor {
        private Clazz checkClass;
        private boolean isRecursing;

        private MyRecursiveCauseChecker() {
        }

        public boolean check(ShortestUsageMark shortestUsageMark, Clazz clazz) {
            this.checkClass = clazz;
            this.isRecursing = false;
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
            return this.isRecursing;
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.checkCause(programClass);
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            this.checkCause(libraryClass);
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            this.checkCause(programField);
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.checkCause(programMethod);
        }

        @Override
        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
            this.checkCause(libraryField);
        }

        @Override
        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
            this.checkCause(libraryMethod);
        }

        private void checkCause(VisitorAccepter visitorAccepter) {
            if (ShortestUsageMarker.this.isUsed(visitorAccepter)) {
                ShortestUsageMark shortestUsageMark = ShortestUsageMarker.this.getShortestUsageMark(visitorAccepter);
                this.isRecursing = shortestUsageMark.isCausedBy(this.checkClass);
                if (!this.isRecursing) {
                    shortestUsageMark.acceptClassVisitor(this);
                    shortestUsageMark.acceptMemberVisitor(this);
                }
            }
        }
    }
}

