/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.concurrency.ThreadContext;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;

final class ContextRunnable
implements Runnable {
    private final boolean myRoot;
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Runnable myRunnable;

    @Async.Schedule
    ContextRunnable(boolean root, @NotNull CoroutineContext context2, @NotNull Runnable runnable) {
        if (context2 == null) {
            ContextRunnable.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            ContextRunnable.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myParentContext = context2;
        this.myRunnable = runnable;
    }

    @Override
    @Async.Execute
    public void run() {
        try (AccessToken ignored = ThreadContext.installThreadContext(this.myParentContext, !this.myRoot);){
            this.myRunnable.run();
        }
    }

    public Runnable getDelegate() {
        return this.myRunnable;
    }

    public String toString() {
        return this.myRunnable.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/concurrency/ContextRunnable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

