/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodStubImpl
extends StubBase<PsiMethod>
implements PsiMethodStub {
    private final TypeInfo myReturnType;
    private final byte myFlags;
    private final String myName;
    private String myDefaultValueText;

    public PsiMethodStubImpl(StubElement parent2, String name2, @NotNull TypeInfo returnType, byte flags, @Nullable String defaultValueText) {
        if (returnType == null) {
            PsiMethodStubImpl.$$$reportNull$$$0(0);
        }
        super(parent2, PsiMethodStubImpl.isAnnotationMethod(flags) ? JavaStubElementTypes.ANNOTATION_METHOD : JavaStubElementTypes.METHOD);
        this.myReturnType = returnType;
        this.myFlags = flags;
        this.myName = name2;
        this.myDefaultValueText = defaultValueText;
    }

    @Override
    public boolean isConstructor() {
        return BitUtil.isSet((int)this.myFlags, 1);
    }

    @Override
    public boolean isVarArgs() {
        return BitUtil.isSet((int)this.myFlags, 2);
    }

    @Override
    public boolean isAnnotationMethod() {
        return PsiMethodStubImpl.isAnnotationMethod(this.myFlags);
    }

    public static boolean isAnnotationMethod(byte flags) {
        return BitUtil.isSet((int)flags, 4);
    }

    @Override
    public String getDefaultValueText() {
        return this.myDefaultValueText;
    }

    @Override
    @NotNull
    public TypeInfo getReturnTypeText() {
        TypeInfo typeInfo = this.myReturnType;
        if (typeInfo == null) {
            PsiMethodStubImpl.$$$reportNull$$$0(1);
        }
        return typeInfo;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet((int)this.myFlags, 8);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet((int)this.myFlags, 16);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet((int)this.myFlags, 32);
    }

    @Override
    public PsiParameterStub findParameter(int idx) {
        StubElement list = null;
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiParameterListStub)) continue;
            list = (PsiParameterListStub)child;
            break;
        }
        if (list != null) {
            List<StubElement> params = list.getChildrenStubs();
            return (PsiParameterStub)params.get(idx);
        }
        throw new RuntimeException("No parameter(s) [yet?]");
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public void setDefaultValueText(String defaultValueText) {
        this.myDefaultValueText = defaultValueText;
    }

    public static byte packFlags(boolean isConstructor, boolean isAnnotationMethod, boolean isVarargs, boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        byte flags = 0;
        if (isConstructor) {
            flags = (byte)(flags | 1);
        }
        if (isAnnotationMethod) {
            flags = (byte)(flags | 4);
        }
        if (isVarargs) {
            flags = (byte)(flags | 2);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 8);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 0x10);
        }
        if (hasDocComment) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiMethodStub[");
        if (this.isConstructor()) {
            builder.append("cons ");
        }
        if (this.isAnnotationMethod()) {
            builder.append("annotation ");
        }
        if (this.isVarArgs()) {
            builder.append("varargs ");
        }
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        builder.append(this.myName).append(":").append(this.myReturnType);
        String defaultValue = this.getDefaultValueText();
        if (defaultValue != null) {
            builder.append(" default=").append(defaultValue);
        }
        builder.append("]");
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

