/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.DynamicMapping;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class PropertyBase
implements PlainJsonSerializable {
    @Nullable
    private final DynamicMapping dynamic;
    @Nonnull
    private final Map<String, Property> fields;
    @Nullable
    private final Integer ignoreAbove;
    @Nonnull
    private final Map<String, String> meta;
    @Nonnull
    private final Map<String, Property> properties;

    protected PropertyBase(AbstractBuilder<?> builder) {
        this.dynamic = ((AbstractBuilder)builder).dynamic;
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.ignoreAbove = ((AbstractBuilder)builder).ignoreAbove;
        this.meta = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
        this.properties = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).properties);
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    @Nonnull
    public final Map<String, Property> fields() {
        return this.fields;
    }

    @Nullable
    public final Integer ignoreAbove() {
        return this.ignoreAbove;
    }

    @Nonnull
    public final Map<String, String> meta() {
        return this.meta;
    }

    @Nonnull
    public final Map<String, Property> properties() {
        return this.properties;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Property> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreAbove != null) {
            generator.writeKey("ignore_above");
            generator.write(this.ignoreAbove.intValue());
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "fields");
        op.add(AbstractBuilder::ignoreAbove, JsonpDeserializer.integerDeserializer(), "ignore_above");
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.add(AbstractBuilder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.dynamic);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.ignoreAbove);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.properties);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyBase other = (PropertyBase)o;
        return Objects.equals(this.dynamic, other.dynamic) && Objects.equals(this.fields, other.fields) && Objects.equals(this.ignoreAbove, other.ignoreAbove) && Objects.equals(this.meta, other.meta) && Objects.equals(this.properties, other.properties);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private Map<String, Property> fields;
        @Nullable
        private Integer ignoreAbove;
        @Nullable
        private Map<String, String> meta;
        @Nullable
        private Map<String, Property> properties;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(PropertyBase o) {
            this.dynamic = o.dynamic;
            this.fields = AbstractBuilder._mapCopy(o.fields);
            this.ignoreAbove = o.ignoreAbove;
            this.meta = AbstractBuilder._mapCopy(o.meta);
            this.properties = AbstractBuilder._mapCopy(o.properties);
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.dynamic = o.dynamic;
            this.fields = AbstractBuilder._mapCopy(o.fields);
            this.ignoreAbove = o.ignoreAbove;
            this.meta = AbstractBuilder._mapCopy(o.meta);
            this.properties = AbstractBuilder._mapCopy(o.properties);
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT fields(Map<String, Property> map) {
            this.fields = AbstractBuilder._mapPutAll(this.fields, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT fields(String key, Property value) {
            this.fields = AbstractBuilder._mapPut(this.fields, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT fields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.fields(key, fn.apply(new Property.Builder()).build());
        }

        @Nonnull
        public final BuilderT ignoreAbove(@Nullable Integer value) {
            this.ignoreAbove = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT meta(Map<String, String> map) {
            this.meta = AbstractBuilder._mapPutAll(this.meta, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT meta(String key, String value) {
            this.meta = AbstractBuilder._mapPut(this.meta, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT properties(Map<String, Property> map) {
            this.properties = AbstractBuilder._mapPutAll(this.properties, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT properties(String key, Property value) {
            this.properties = AbstractBuilder._mapPut(this.properties, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }
    }
}

