/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphBuilder;
import androidx.compose.ui.text.platform.ParagraphLayouter_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.Paragraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0012\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u001bH\u0002J\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b,\u0010-J\u0016\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0003J\u0015\u00102\u001a\u00020&2\u0006\u00103\u001a\u000204\u00a2\u0006\u0004\b5\u00106J'\u00107\u001a\u00020&2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001d\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010?\u001a\u00020&2\u0006\u0010:\u001a\u00020;\u00a2\u0006\u0004\b@\u00106J\u001a\u0010A\u001a\u00020&2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010EJ\u0010\u0010F\u001a\u00020&2\b\u0010G\u001a\u0004\u0018\u00010HJ\u0015\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020K\u00a2\u0006\u0004\bL\u0010MJ\u000e\u0010N\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006O"}, d2={"Landroidx/compose/ui/text/platform/ParagraphLayouter;", "", "text", "", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "style", "Landroidx/compose/ui/text/TextStyle;", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "placeholders", "Landroidx/compose/ui/text/Placeholder;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "<init>", "(Ljava/lang/String;Landroidx/compose/ui/text/style/ResolvedTextDirection;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "getText", "()Ljava/lang/String;", "builder", "Landroidx/compose/ui/text/platform/ParagraphBuilder;", "paragraphCache", "Lorg/jetbrains/skia/paragraph/Paragraph;", "updateForeground", "", "width", "", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont", "()Lorg/jetbrains/skia/Font;", "textStyle", "getTextStyle", "()Landroidx/compose/ui/text/TextStyle;", "invalidateParagraph", "", "onlyForeground", "emptyLineMetrics", "", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "paragraph", "emptyLineMetrics$ui_text", "(Lorg/jetbrains/skia/paragraph/Paragraph;)[Lorg/jetbrains/skia/paragraph/LineMetrics;", "setParagraphStyle", "maxLines", "", "ellipsis", "setColor", "color", "Landroidx/compose/ui/graphics/Color;", "setColor-8_81llA", "(J)V", "setBrush", "brush", "Landroidx/compose/ui/graphics/Brush;", "brushSize", "Landroidx/compose/ui/geometry/Size;", "alpha", "setBrush-12SF9DM", "(Landroidx/compose/ui/graphics/Brush;JF)V", "setBrushSize", "setBrushSize-uvyYCjk", "setTextStyle", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "setDrawStyle", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "setBlendMode", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "setBlendMode-s9anfk8", "(I)V", "layoutParagraph", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nParagraphLayouter.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 4 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,224:1\n646#2:225\n635#2:226\n141#3:227\n57#4:228\n61#4:231\n60#5:229\n70#5:232\n22#6:230\n22#6:233\n103#7:234\n35#7,5:235\n104#7:240\n*S KotlinDebug\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n*L\n114#1:225\n114#1:226\n130#1:227\n131#1:228\n132#1:231\n131#1:229\n132#1:232\n131#1:230\n132#1:233\n154#1:234\n154#1:235,5\n154#1:240\n*E\n"})
public final class ParagraphLayouter {
    @NotNull
    private final String text;
    @NotNull
    private final ParagraphBuilder builder;
    @Nullable
    private Paragraph paragraphCache;
    private boolean updateForeground;
    private float width;
    public static final int $stable = 8;

    public ParagraphLayouter(@NotNull String text, @NotNull ResolvedTextDirection textDirection, @NotNull TextStyle style, @NotNull List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text;
        this.builder = new ParagraphBuilder(fontFamilyResolver, this.text, style, 0L, null, 0, annotations, placeholders, density, textDirection, null, 0, 3128, null);
        this.width = Float.NaN;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Font getDefaultFont() {
        return this.builder.getDefaultFont$ui_text();
    }

    @NotNull
    public final TextStyle getTextStyle() {
        return this.builder.getTextStyle();
    }

    private final void invalidateParagraph(boolean onlyForeground) {
        if (onlyForeground && this.builder.getAnnotations().isEmpty()) {
            this.updateForeground = true;
        } else {
            this.paragraphCache = null;
        }
    }

    static /* synthetic */ void invalidateParagraph$default(ParagraphLayouter paragraphLayouter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        paragraphLayouter.invalidateParagraph(bl);
    }

    @NotNull
    public final LineMetrics[] emptyLineMetrics$ui_text(@NotNull Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        return this.builder.emptyLineMetrics$ui_text(paragraph);
    }

    public final void setParagraphStyle(int maxLines, @NotNull String ellipsis) {
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        if (this.builder.getMaxLines() != maxLines || !Intrinsics.areEqual((Object)this.builder.getEllipsis(), (Object)ellipsis)) {
            this.builder.setMaxLines(maxLines);
            this.builder.setEllipsis(ellipsis);
            ParagraphLayouter.invalidateParagraph$default(this, false, 1, null);
        }
    }

    public final void setColor-8_81llA(long color) {
        long l;
        long $this$takeOrElse_u2dDxMtmZc$iv = color;
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != 16L) {
            l = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            boolean bl3 = false;
            l = this.builder.getTextStyle().getColor-0d7_KjU();
        }
        long actualColor = l;
        if (!Color.equals-impl0(this.builder.getTextStyle().getColor-0d7_KjU(), actualColor)) {
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default(this.builder.getTextStyle(), actualColor, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFE, null));
            this.invalidateParagraph(true);
        }
    }

    public final void setBrush-12SF9DM(@Nullable Brush brush, long brushSize, float alpha) {
        block3: {
            block2: {
                long actualSize = this.builder.getBrushSize-NH-jbRc();
                if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getBrush(), (Object)brush)) break block2;
                long $this$isUnspecified$iv = actualSize;
                boolean bl = false;
                if ($this$isUnspecified$iv == 9205357640488583168L) break block2;
                long arg0$iv = actualSize;
                boolean bl2 = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                float f = Float.intBitsToFloat(bits$iv$iv$iv);
                arg0$iv = brushSize;
                bl2 = false;
                value$iv$iv = arg0$iv;
                $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits = false;
                if (!ParagraphLayouter_skikoKt.access$sameValueAs(f, Float.intBitsToFloat(bits$iv$iv$iv))) break block2;
                arg0$iv = actualSize;
                boolean bl3 = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                float f2 = Float.intBitsToFloat(bits$iv$iv$iv);
                arg0$iv = brushSize;
                bl3 = false;
                value$iv$iv = arg0$iv;
                $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                if (ParagraphLayouter_skikoKt.access$sameValueAs(f2, Float.intBitsToFloat(bits$iv$iv$iv)) && ParagraphLayouter_skikoKt.access$sameValueAs(this.builder.getTextStyle().getAlpha(), alpha)) break block3;
            }
            this.builder.setTextStyle(TextStyle.copy-Ns73l9s$default(this.builder.getTextStyle(), brush, alpha, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0x1FFFFFC, null));
            this.builder.setBrushSize-uvyYCjk(brushSize);
            this.invalidateParagraph(true);
        }
    }

    public final void setBrushSize-uvyYCjk(long brushSize) {
        block4: {
            block5: {
                boolean bl;
                block3: {
                    if (Size.equals-impl0(this.builder.getBrushSize-NH-jbRc(), brushSize)) break block4;
                    this.builder.setBrushSize-uvyYCjk(brushSize);
                    if (this.builder.getTextStyle().getBrush() instanceof ShaderBrush) break block5;
                    List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> $this$fastAny$iv = this.builder.getAnnotations();
                    boolean $i$f$fastAny = false;
                    List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                    boolean $i$f$fastForEach = false;
                    int n = ((Collection)$this$fastForEach$iv$iv).size();
                    for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        AnnotatedString.Range<? extends AnnotatedString.Annotation> item$iv$iv;
                        AnnotatedString.Range<? extends AnnotatedString.Annotation> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        boolean bl2 = false;
                        AnnotatedString.Range<? extends AnnotatedString.Annotation> it = it$iv;
                        boolean bl3 = false;
                        if (!(it.getItem() instanceof SpanStyle && ((SpanStyle)it.getItem()).getBrush() instanceof ShaderBrush)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) break block4;
            }
            this.invalidateParagraph(true);
        }
    }

    public final void setTextStyle(@Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow) || !Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration)) {
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default(this.builder.getTextStyle(), 0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, textDecoration, shadow, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFCFFF, null));
            ParagraphLayouter.invalidateParagraph$default(this, false, 1, null);
        }
    }

    public final void setDrawStyle(@Nullable DrawStyle drawStyle) {
        if (!Intrinsics.areEqual((Object)this.builder.getDrawStyle(), (Object)drawStyle)) {
            this.builder.setDrawStyle(drawStyle);
            this.invalidateParagraph(true);
        }
    }

    public final void setBlendMode-s9anfk8(int blendMode) {
        if (!BlendMode.equals-impl0(this.builder.getBlendMode-0nO6VwU(), blendMode)) {
            this.builder.setBlendMode-s9anfk8(blendMode);
            ParagraphLayouter.invalidateParagraph$default(this, false, 1, null);
        }
    }

    @NotNull
    public final Paragraph layoutParagraph(float width) {
        Paragraph paragraph = this.paragraphCache;
        if (paragraph != null) {
            boolean layoutRequired = false;
            if (this.updateForeground) {
                this.builder.updateForegroundPaint(paragraph);
                this.updateForeground = false;
                paragraph.markDirty();
                layoutRequired = true;
            }
            if (!ParagraphLayouter_skikoKt.access$sameValueAs(this.width, width)) {
                this.width = width;
                layoutRequired = true;
            }
            if (layoutRequired) {
                paragraph.layout(width);
            }
        } else {
            paragraph = this.builder.build();
            paragraph.layout(width);
            this.paragraphCache = paragraph;
            this.updateForeground = false;
            return paragraph;
        }
        return paragraph;
    }
}

