/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.Nullable;

public final class NodeRuleMatch
extends RuleMatch {
    private final NodeMatch result;

    public NodeRuleMatch(Rule rule, NodeMatch result) {
        super(rule, result.message());
        this.result = result;
        if (this.message() == null && result.preventedBy == null && result.metadata.isEmpty()) {
            throw new IllegalArgumentException("Matches must have either a message or metadata: " + String.valueOf(rule));
        }
    }

    public NodeMatch result() {
        return this.result;
    }

    @Override
    public List<ProblemFix> problemFixes() {
        return this.result.problemFixes();
    }

    @Override
    public List<TextRange> reportedRanges() {
        return this.result.reportedRanges();
    }

    @Override
    public List<TextRange> hoverReportedRanges() {
        return this.result.hoverReportedRanges();
    }

    @Override
    public List<ActionSuggestion> actions() {
        return this.result.actions;
    }

    @Override
    @Nullable
    public NodeMatch.SuppressableKind suppressableKind() {
        return this.result.suppressableKind;
    }

    @Override
    public boolean autoFixCapable() {
        return this.result.autoFixCapable;
    }

    @Override
    public boolean hasLowConfidence() {
        return this.result.hasLowConfidence;
    }

    @Override
    public boolean concedeToOtherGrammarCheckers() {
        return super.concedeToOtherGrammarCheckers() || this.result.concedeToOtherGrammarCheckers;
    }

    @Override
    public List<TextChange> correctionChanges() {
        return this.result.calcCorrectionChanges();
    }

    @Override
    public Pair<TextRange, List<String>> singleRangeReplacements(String text) {
        TextRange range = this.result.replacementRange();
        return new Pair((Object)range, this.correctionChanges().stream().map(c -> c.performOnRange(text, range)).distinct().toList());
    }

    public String toString() {
        return "NodeRuleMatch[rule=" + String.valueOf(this.rule()) + ", result=" + String.valueOf(this.result) + "]";
    }
}

