/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.openapi.Disposable;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridListModelBase<Row, Column>
implements GridModel<Row, Column> {
    private List<Column> myColumns;
    private final List<Row> myRows;
    private boolean myUpdatingNow;

    public GridListModelBase() {
        this(new ArrayList(), new ArrayList());
    }

    public GridListModelBase(List<Column> columns, List<Row> rows) {
        this.myColumns = columns;
        this.myRows = rows;
    }

    @Override
    public boolean hasListeners() {
        return false;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<Row> rowIdx, ModelIndex<Column> columnIdx) {
        Row row = this.getRow(rowIdx);
        Column column = this.getColumn(columnIdx);
        return row != null && column != null ? this.getValueAt(row, column) : null;
    }

    @Override
    @Nullable
    public Row getRow(@NotNull ModelIndex<Row> row) {
        if (row == null) {
            GridListModelBase.$$$reportNull$$$0(0);
        }
        return this.getRow(row.asInteger());
    }

    @Override
    @Nullable
    public Column getColumn(@NotNull ModelIndex<Column> column) {
        if (column == null) {
            GridListModelBase.$$$reportNull$$$0(1);
        }
        return this.getColumn(column.asInteger());
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull ModelIndexSet<Row> rows) {
        if (rows == null) {
            GridListModelBase.$$$reportNull$$$0(2);
        }
        ArrayList<Row> result = new ArrayList<Row>(rows.size());
        for (int rowIndex : rows.asArray()) {
            result.add(this.getRow(rowIndex));
        }
        ArrayList<Row> arrayList = result;
        if (arrayList == null) {
            GridListModelBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Column> getColumns(@NotNull ModelIndexSet<Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(4);
        }
        List list = this.getColumnsAsIterable(columns).toList();
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public JBIterable<Column> getColumnsAsIterable(@NotNull ModelIndexSet<Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = columns.asIterable().transform(this::getColumn);
        if (jBIterable == null) {
            GridListModelBase.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<Column> getColumnsAsIterable() {
        JBIterable jBIterable = JBIterable.from(Collections.unmodifiableList(this.myColumns));
        if (jBIterable == null) {
            GridListModelBase.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<Column> getColumns() {
        List<Column> list = Collections.unmodifiableList(this.myColumns);
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Row> getRows() {
        List<Row> list = Collections.unmodifiableList(this.myRows);
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public ModelIndexSet<Column> getColumnIndices() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forColumns(this, GridListModelBase.range(0, this.getColumnCount()));
        if (modelIndexSet == null) {
            GridListModelBase.$$$reportNull$$$0(11);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<Row> getRowIndices() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows(this, GridListModelBase.range(0, this.getRowCount()));
        if (modelIndexSet == null) {
            GridListModelBase.$$$reportNull$$$0(12);
        }
        return modelIndexSet;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.myRows.size();
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myUpdatingNow;
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<Row> rowIdx) {
        if (rowIdx == null) {
            GridListModelBase.$$$reportNull$$$0(13);
        }
        return GridListModelBase.isValidIdx(this.myRows, rowIdx.asInteger());
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<Column> columnIdx) {
        if (columnIdx == null) {
            GridListModelBase.$$$reportNull$$$0(14);
        }
        return GridListModelBase.isValidIdx(this.myColumns, columnIdx.asInteger());
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<Row, Column> l, @NotNull Disposable disposable) {
        if (l == null) {
            GridListModelBase.$$$reportNull$$$0(15);
        }
        if (disposable == null) {
            GridListModelBase.$$$reportNull$$$0(16);
        }
    }

    @Nullable
    protected abstract Object getValueAt(@NotNull Row var1, @NotNull Column var2);

    public abstract boolean allValuesEqualTo(@NotNull List<CellMutation> var1);

    public void setUpdatingNow(boolean updatingNow) {
        this.myUpdatingNow = updatingNow;
    }

    public void addRows(@NotNull List<? extends Row> rows) {
        if (rows == null) {
            GridListModelBase.$$$reportNull$$$0(17);
        }
        this.myRows.addAll(rows);
    }

    public void addRow(@NotNull Row row) {
        if (row == null) {
            GridListModelBase.$$$reportNull$$$0(18);
        }
        this.myRows.add(row);
    }

    public void removeRows(int firstRowIndex, int rowCount) {
        GridListModelBase.removeRange(this.myRows, firstRowIndex, rowCount);
    }

    public void setColumns(@NotNull List<? extends Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(19);
        }
        this.myColumns.addAll(columns);
    }

    private Row getRow(int rowIdx) {
        return GridListModelBase.isValidIdx(this.myRows, rowIdx) ? (Row)this.myRows.get(rowIdx) : null;
    }

    private Column getColumn(int columnIdx) {
        return GridListModelBase.isValidIdx(this.myColumns, columnIdx) ? (Column)this.myColumns.get(columnIdx) : null;
    }

    public void clearColumns() {
        this.myColumns = new ArrayList<Column>();
    }

    public void set(int i, Row row) {
        this.myRows.set(i, row);
    }

    private static boolean isValidIdx(@NotNull List<?> list, int idx) {
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(20);
        }
        return idx > -1 && idx < list.size();
    }

    private static int[] range(int first, int length) {
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = first + i;
        }
        return range;
    }

    private static void removeRange(List<?> list, int firstIdx, int count) {
        for (int i = 0; i < count; ++i) {
            list.remove(firstIdx + count - i - 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridListModelBase";
                break;
            }
            case 4: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridListModelBase";
                break;
            }
            case 3: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsAsIterable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnIndices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColumnsAsIterable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isValidIdx";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

