# -*- coding: utf-8 -*-
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#
#  Author: Mauro Soria

import os
import sys
import string
import time

from lib.utils.file import FileUtils

# Version format: <major version>.<minor version>.<revision>[.<month>]
VERSION = "0.4.3"

BANNER = f"""
  _|. _ _  _  _  _ _|_    v{VERSION}
 (_||| _) (/_(_|| (_| )
"""

COMMAND = " ".join(sys.argv)

START_TIME = time.strftime("%Y-%m-%d %H:%M:%S")

SCRIPT_PATH = FileUtils.parent(__file__, 3)

IS_WINDOWS = sys.platform in ("win32", "msys")

WORDLIST_CATEGORY_DIR = FileUtils.build_path(SCRIPT_PATH, "db", "categories")
WORDLIST_CATEGORIES = {
    "extensions": "extensions.txt",
    "conf": "conf.txt",
    "vcs": "vcs.txt",
    "backups": "backups.txt",
    "db": "db.txt",
    "logs": "logs.txt",
    "keys": "keys.txt",
    "web": "web.txt",
    "common": "common.txt",

    # PHP
    "php/laravel": "php/laravel.txt",
    "php/wordpress": "php/wordpress.txt",
    "php/codeigniter": "php/codeigniter.txt",
    "php/symfony": "php/symfony.txt",
    "php/yii": "php/yii.txt",
    "php/cakephp": "php/cakephp.txt",
    "php/joomla": "php/joomla.txt",
    "php/drupal": "php/drupal.txt",
    "php/magento": "php/magento.txt",

    # .NET
    "dotnet/aspx": "dotnet/aspx.txt",
    "dotnet/mvc": "dotnet/mvc.txt",
    "dotnet/core": "dotnet/core.txt",

    # ColdFusion
    "coldfusion": "coldfusion/coldfusion.txt",

    # Java
    "java/jsp": "java/jsp.txt",
    "java/jsf": "java/jsf.txt",
    "java/spring": "java/spring.txt",

    # Python
    "python/django": "python/django.txt",
    "python/flask": "python/flask.txt",
    "python/fastapi": "python/fastapi.txt",

    # Node
    "node/express": "node/express.txt",

    # Infra
    "infra/docker": "infra/docker.txt",
    "infra/k8s": "infra/k8s.txt",
    "infra/aws": "infra/aws.txt",
}

DEFAULT_ENCODING = "utf-8"

NEW_LINE = os.linesep

INVALID_CHARS_FOR_WINDOWS_FILENAME = ('"', "*", "<", ">", "?", "\\", "|", "/", ":")

INVALID_FILENAME_CHAR_REPLACEMENT = "_"

FILE_BASED_OUTPUT_FORMATS = ("simple", "plain", "json", "xml", "md", "csv", "html", "sqlite")

COMMON_EXTENSIONS = ("php", "jsp", "asp", "aspx", "do", "action", "cgi", "html", "htm", "js", "tar.gz")

MEDIA_EXTENSIONS = ("webm", "mkv", "avi", "ts", "mov", "qt", "amv", "mp4", "m4p", "m4v", "mp3", "swf", "mpg", "mpeg", "jpg", "jpeg", "pjpeg", "png", "woff", "svg", "webp", "bmp", "pdf", "wav", "vtt")

EXCLUDE_OVERWRITE_EXTENSIONS = MEDIA_EXTENSIONS + ("axd", "cache", "coffee", "conf", "config", "css", "dll", "lock", "log", "key", "pub", "properties", "ini", "jar", "js", "json", "toml", "txt", "xml", "yaml", "yml")

CRAWL_ATTRIBUTES = ("action", "cite", "data", "formaction", "href", "longdesc", "poster", "src", "srcset", "xmlns")

CRAWL_TAGS = ("a", "area", "base", "blockquote", "button", "embed", "form", "frame", "frameset", "html", "iframe", "input", "ins", "noframes", "object", "q", "script", "source")

AUTHENTICATION_TYPES = ("basic", "digest", "bearer", "ntlm", "jwt")

PROXY_SCHEMES = ("http://", "https://", "socks5://", "socks5h://", "socks4://", "socks4a://")

STANDARD_PORTS = {"http": 80, "https": 443}

DEFAULT_TEST_PREFIXES = (".", ".ht")

DEFAULT_TEST_SUFFIXES = ("/", "~")

DEFAULT_TOR_PROXIES = ("socks5://127.0.0.1:9050", "socks5://127.0.0.1:9150")

DEFAULT_HEADERS = {
    "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36",
    "accept": "*/*",
    "accept-encoding": "*",
    "keep-alive": "timeout=15, max=1000",
    "cache-control": "max-age=0",
}

def _get_default_session_dir() -> str:
    if getattr(sys, "frozen", False) or hasattr(sys, "_MEIPASS"):
        home_dir = os.path.expanduser("~")
        return FileUtils.build_path(home_dir, ".dirsearch", "sessions")
    return FileUtils.build_path(SCRIPT_PATH, "sessions")


DEFAULT_SESSION_DIR = _get_default_session_dir()
DEFAULT_SESSION_FILE = FileUtils.build_path(
    DEFAULT_SESSION_DIR,
    "{date}",
    "session_{datetime}",
)

REFLECTED_PATH_MARKER = "__REFLECTED_PATH__"

WILDCARD_TEST_POINT_MARKER = "__WILDCARD_POINT__"

EXTENSION_TAG = "%ext%"

EXTENSION_RECOGNITION_REGEX = r"\w+([.][a-zA-Z0-9]{2,5}){1,3}~?$"

QUERY_STRING_REGEX = r"^(\&?([^=& ]+)\=([^=& ]+)?){1,200}$"

READ_RESPONSE_ERROR_REGEX = r"(ChunkedEncodingError|StreamConsumedError|UnrewindableBodyError)"

URI_REGEX = r"^[a-z]{2,}:"

ROBOTS_TXT_REGEX = r"(?:Allow|Disallow): /(.*)"

UNKNOWN = "unknown"

TMP_PATH = "/tmp/dirsearch"

DUMMY_DOMAIN = "example.com"

DUMMY_URL = "https://example.com/"

DUMMY_WORD = "dummyasdf"

DB_CONNECTION_TIMEOUT = 45

SOCKET_TIMEOUT = 6

RATE_UPDATE_DELAY = 0.15

ITER_CHUNK_SIZE = 1024 * 1024

MAX_RESPONSE_SIZE = 80 * 1024 * 1024

TEST_PATH_LENGTH = 6

MAX_CONSECUTIVE_REQUEST_ERRORS = 75

# Signal handling settings for PyInstaller Linux builds
# Time window (seconds) for detecting rapid consecutive Ctrl+C presses
SIGINT_WINDOW_SECONDS = 0.8
# Number of rapid Ctrl+C presses required to force quit
SIGINT_FORCE_QUIT_THRESHOLD = 3

URL_SAFE_CHARS = string.punctuation

TEXT_CHARS = bytearray({7, 8, 9, 10, 12, 13, 27} | set(range(0x20, 0x100)) - {0x7F})
