/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class DoubleArrowIcon
implements Icon {
    private static final Color WHITE_60A = new Color(255, 255, 255, 60);
    private static final Color GRAY = new Color(49, 52, 49);
    Orientation orientation;

    public DoubleArrowIcon() {
        this(Orientation.LEFT);
    }

    public DoubleArrowIcon(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getIconHeight() {
        return this.orientation.getHeight();
    }

    @Override
    public int getIconWidth() {
        return this.orientation.getWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.orientation.getImage() == null) {
            GraphicsConfiguration dc = g2d.getDeviceConfiguration();
            BufferedImage bi = dc.createCompatibleImage(this.orientation.getWidth(), this.orientation.getHeight(), 3);
            Graphics2D g2 = bi.createGraphics();
            g2.rotate(this.orientation.getRotation(), 5.0, 4.0);
            this.paintArrow(g2, 0, 0);
            this.paintArrow(g2, 4, 0);
            g2.dispose();
            this.orientation.setImage(bi);
        }
        g2d.drawImage((Image)this.orientation.getImage(), x, y, null);
    }

    protected void paintArrow(Graphics2D g2d, int x, int y) {
        g2d.setColor(GRAY);
        g2d.drawLine(x + 4, y + 1, x + 1, y + 4);
        g2d.drawLine(x + 4, y + 2, x + 2, y + 4);
        g2d.drawLine(x + 2, y + 5, x + 4, y + 7);
        g2d.drawLine(x + 3, y + 5, x + 4, y + 6);
        g2d.setColor(WHITE_60A);
        g2d.drawLine(x + 4, y, x, y + 4);
        g2d.drawLine(x + 1, y + 5, x + 4, y + 8);
        g2d.drawLine(x + 5, y, x + 5, y + 2);
        g2d.drawLine(x + 4, y + 3, x + 3, y + 4);
        g2d.drawLine(x + 4, y + 5, x + 5, y + 6);
        g2d.drawLine(x + 5, y + 7, x + 5, y + 8);
    }

    public static enum Orientation {
        UP(Math.toRadians(90.0), 9, 10),
        DOWN(Math.toRadians(-90.0), 9, 10),
        LEFT(Math.toRadians(0.0), 10, 9),
        RIGHT(Math.toRadians(180.0), 10, 9);

        double rotation;
        int width;
        int height;
        BufferedImage image;

        private Orientation(double radians, int width, int height) {
            this.rotation = radians;
            this.width = width;
            this.height = height;
        }

        public double getRotation() {
            return this.rotation;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }
    }
}

