/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.PanelUI;
import org.officelaf.ribbon.OfficeCommandButtonPanelUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel1;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class OfficeRibbonApplicationMenuPopupPanel
extends JPopupPanel {
    private static final Color BORDER_COLOR = new Color(255);
    private static final Color BORDER_HIGHLIGHT1_COLOR = new Color(255);
    private static final Color BORDER_HIGHLIGHT2_COLOR = new Color(255);
    private static final Color FOOTER_GRADIENT_1 = new Color(0xFF00FF);
    private static final Color FOOTER_HIGHLIGHT = new Color(65535);
    private static final Color TOP_HIGHLIGHT_GRADIENT_1 = new Color(0x636262);
    private static final Color MAIN_FILL = new Color(65535);
    private static final Color[] GRADIENTS = new Color[]{FOOTER_GRADIENT_1};
    protected JCommandButtonPanel panelLevel1;
    protected JPanel panelLevel2;
    protected JPanel footerPanel;
    protected RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback defaultPrimaryCallback;
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_1 = new CommandButtonDisplayState("Ribbon application menu tile level 1", 32){

        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel1();
        }
    };

    public OfficeRibbonApplicationMenuPopupPanel(final JRibbonApplicationMenuButton button, RibbonApplicationMenu ribbonAppMenu) {
        List primaryEntries;
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(BORDER_COLOR, BORDER_HIGHLIGHT1_COLOR, new Insets(14, 2, 0, 2)){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                super.paintBorder(c, g, x, y, width, height);
                JRibbonApplicationMenuButton rendererButton = new JRibbonApplicationMenuButton(button.getRibbon());
                rendererButton.setIcon(button.getIcon());
                rendererButton.getPopupModel().setRollover(false);
                rendererButton.getPopupModel().setPressed(true);
                rendererButton.getPopupModel().setArmed(true);
                rendererButton.getPopupModel().setPopupShowing(true);
                CellRendererPane buttonRendererPane = new CellRendererPane();
                Point buttonLoc = button.getLocationOnScreen();
                Point panelLoc = c.getLocationOnScreen();
                buttonRendererPane.setBounds(panelLoc.x - buttonLoc.x, panelLoc.y - buttonLoc.y, button.getWidth(), button.getHeight());
                buttonRendererPane.paintComponent(g, (Component)rendererButton, (Container)c, -panelLoc.x + buttonLoc.x, -panelLoc.y + buttonLoc.y, button.getWidth(), button.getHeight(), true);
            }
        });
        this.defaultPrimaryCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

            public void menuEntryActivated(JPanel targetPanel) {
                targetPanel.removeAll();
                targetPanel.revalidate();
                targetPanel.repaint();
            }
        };
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new LineBorder(BORDER_HIGHLIGHT2_COLOR, BORDER_COLOR));
        this.panelLevel1 = new JCommandButtonPanel(MENU_TILE_LEVEL_1);
        this.panelLevel1.setUI((PanelUI)((Object)new OfficeCommandButtonPanelUI(){

            @Override
            protected Insets getGroupInsets() {
                return new Insets(0, 0, 0, 0);
            }

            protected int getLayoutGap() {
                return 0;
            }
        }));
        this.panelLevel1.setBackground(new Color(250, 250, 250));
        this.panelLevel1.setMaxButtonColumns(1);
        this.panelLevel1.setBorder(BorderFactory.createEmptyBorder());
        this.panelLevel1.addButtonGroup("main");
        this.panelLevel1.setToShowGroupLabels(false);
        if (ribbonAppMenu != null && (primaryEntries = ribbonAppMenu.getPrimaryEntries()) != null && primaryEntries.size() > 0) {
            for (final RibbonApplicationMenuEntryPrimary menuEntry : (List)primaryEntries.get(0)) {
                final JCommandMenuButton commandButton = new JCommandMenuButton(menuEntry.getText(), menuEntry.getIcon());
                commandButton.setCommandButtonKind(menuEntry.getEntryKind());
                commandButton.addActionListener(menuEntry.getMainActionListener());
                if (menuEntry.getSecondaryGroupCount() == 0) {
                    commandButton.addRolloverActionListener(new RolloverActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            OfficeRibbonApplicationMenuPopupPanel.this.defaultPrimaryCallback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanel.this.panelLevel2);
                        }
                    });
                } else {
                    final RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback coreCallback = new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

                        public void menuEntryActivated(JPanel targetPanel) {
                            targetPanel.removeAll();
                            targetPanel.setLayout(new BorderLayout());
                            JRibbonApplicationMenuPopupPanelSecondary secondary = new JRibbonApplicationMenuPopupPanelSecondary(menuEntry){

                                public void removeNotify() {
                                    super.removeNotify();
                                    commandButton.getPopupModel().setPopupShowing(false);
                                }
                            };
                            JScrollPane scrollPane = new JScrollPane((Component)secondary, 20, 31);
                            Dimension prefSize = secondary.getPreferredSize();
                            secondary.setPreferredSize(new Dimension(targetPanel.getPreferredSize().width - scrollPane.getVerticalScrollBar().getPreferredSize().width, prefSize.height));
                            targetPanel.add((Component)scrollPane, "Center");
                            targetPanel.revalidate();
                        }
                    };
                    commandButton.addRolloverActionListener(new RolloverActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            coreCallback.menuEntryActivated(OfficeRibbonApplicationMenuPopupPanel.this.panelLevel2);
                            commandButton.getPopupModel().setPopupShowing(true);
                        }
                    });
                }
                commandButton.setDisplayState(MENU_TILE_LEVEL_1);
                commandButton.setHorizontalAlignment(10);
                commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                commandButton.setEnabled(menuEntry.isEnabled());
                commandButton.setVisible(menuEntry.isVisible());
                this.panelLevel1.addButtonToLastGroup((AbstractCommandButton)commandButton);
            }
        }
        mainPanel.add((Component)this.panelLevel1, "West");
        this.panelLevel2 = new JPanel();
        this.panelLevel2.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 1, 0, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(new Color(197, 197, 197));
                g.drawLine(x, y, x, y + height);
            }
        });
        this.panelLevel2.setPreferredSize(new Dimension(30 * FlamingoUtilities.getFont((Component)this.panelLevel1, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"}).getSize() - 30, 10));
        mainPanel.add((Component)this.panelLevel2, "Center");
        this.add(mainPanel, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        this.footerPanel = new JPanel(gridbag){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(GRADIENTS[0]);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight() - 2);
                g2d.setColor(FOOTER_HIGHLIGHT);
                g2d.fillRect(0, this.getHeight() - 2, this.getWidth(), 2);
            }
        };
        this.footerPanel.setBorder(new EmptyBorder(2, 0, 1, 1));
        GridBagConstraints c = new GridBagConstraints();
        Insets buttonSpacing = new Insets(0, 6, 0, 0);
        c.weightx = 1.0;
        this.footerPanel.add((Component)new JLabel(" "), c);
        c.weightx = 0.0;
        if (ribbonAppMenu != null) {
            for (int i = 0; i < ribbonAppMenu.getFooterEntries().size(); ++i) {
                RibbonApplicationMenuEntryFooter footerEntry = (RibbonApplicationMenuEntryFooter)ribbonAppMenu.getFooterEntries().get(i);
                JCommandButton commandFooterButton = new JCommandButton(footerEntry.getText(), footerEntry.getIcon());
                commandFooterButton.setDisabledIcon((ResizableIcon)new FilteredResizableIcon(footerEntry.getIcon(), (BufferedImageOp)new ColorConvertOp(ColorSpace.getInstance(1003), null)));
                commandFooterButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                commandFooterButton.addActionListener(footerEntry.getMainActionListener());
                commandFooterButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
                commandFooterButton.setFlat(false);
                commandFooterButton.setEnabled(footerEntry.isEnabled());
                c.gridx = i + 1;
                if (i > 0) {
                    c.insets = buttonSpacing;
                }
                this.footerPanel.add((Component)commandFooterButton, c);
            }
        }
        this.add(this.footerPanel, "South");
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setPaint(TOP_HIGHLIGHT_GRADIENT_1);
        g2d.fillRect(0, 0, width, 6);
        g2d.setPaint(MAIN_FILL);
        g2d.fillRect(0, 6, width, height - 6);
    }

    protected static class LineBorder
    extends AbstractBorder {
        private Color outer;
        private Color inner;
        private Insets padding;

        public LineBorder(Color outer, Color inner) {
            this(outer, inner, new Insets(0, 0, 0, 0));
        }

        public LineBorder(Color outer, Color inner, Insets padding) {
            this.outer = outer;
            this.inner = inner;
            this.padding = padding;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, super.getBorderInsets(c));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 2 + this.padding.left;
            insets.top = 2 + this.padding.top;
            insets.right = 2 + this.padding.right;
            insets.bottom = 2 + this.padding.bottom;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.outer);
            g.drawRect(x, y, width - 1, height - 1);
            g.setColor(this.inner);
            g.drawRect(x + 1, y + 1, width - 3, height - 3);
        }
    }
}

