/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import com.pinkmatter.modules.flamingo.ActionItem;
import com.pinkmatter.modules.flamingo.ActionItems;
import com.pinkmatter.modules.flamingo.RibbonComponentFactory;
import com.pinkmatter.spi.flamingo.RibbonAppMenuProvider;
import com.pinkmatter.spi.flamingo.RibbonComponentProvider;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class LayerRibbonComponentProvider
extends RibbonComponentProvider {
    @Override
    public JComponent createRibbon() {
        JRibbon ribbon = new JRibbon();
        LayerRibbonComponentProvider.addAppMenu(ribbon);
        LayerRibbonComponentProvider.addTaskBar(ribbon);
        this.addTaskPanes(ribbon);
        this.addHelpButton(ribbon);
        return ribbon;
    }

    private static void addAppMenu(JRibbon ribbon) {
        RichTooltip appMenuTooltip;
        RibbonAppMenuProvider appMenuProvider = RibbonAppMenuProvider.getDefault();
        RibbonApplicationMenu appMenu = appMenuProvider.createApplicationMenu();
        if (appMenu != null) {
            ribbon.setApplicationMenu(appMenu);
        }
        if ((appMenuTooltip = appMenuProvider.createApplicationMenuTooltip()) != null) {
            ribbon.setApplicationMenuRichTooltip(appMenuTooltip);
        }
    }

    private static void addTaskBar(JRibbon ribbon) {
        List<? extends ActionItem> actions = ActionItems.forPath("Ribbon/TaskBar");
        RibbonComponentFactory factory = new RibbonComponentFactory();
        for (ActionItem actionItem : actions) {
            if (actionItem.isSeparator()) {
                ribbon.addTaskbarComponent((Component)new JSeparator(1));
                continue;
            }
            ribbon.addTaskbarComponent(factory.createTaskBarPresenter(actionItem));
        }
    }

    private void addHelpButton(JRibbon ribbon) {
        List<? extends ActionItem> actions = ActionItems.forPath("Ribbon/HelpButton");
        if (actions.size() > 0) {
            ribbon.configureHelp(actions.get(0).getIcon(), (ActionListener)actions.get(0).getAction());
        }
    }

    private void addTaskPanes(JRibbon ribbon) {
        RibbonComponentFactory factory = new RibbonComponentFactory();
        ActionItems.forPath("Ribbon/TaskPanes").parallelStream().map(item -> {
            RibbonTask task = factory.createRibbonTask((ActionItem)item);
            if (task != null) {
                RichTooltip toolTip = item.getActionDelegate().createTooltip();
                task.setRichTooltip(toolTip);
            }
            return task;
        }).filter(Objects::nonNull).forEachOrdered(arg_0 -> ((JRibbon)ribbon).addTask(arg_0));
    }
}

