/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.utils.StringUtil;

public interface UserQueryMethodsProvider {
    @Deprecated
    default public Stream<UserModel> searchForUserStream(RealmModel realm, String search) {
        return this.searchForUserStream(realm, Map.of("keycloak.session.realm.users.query.search", search), null, null);
    }

    @Deprecated
    default public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        return this.searchForUserStream(realm, Map.of("keycloak.session.realm.users.query.search", search), firstResult, maxResults);
    }

    default public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params) {
        return this.searchForUserStream(realm, params, null, null);
    }

    public Stream<UserModel> searchForUserStream(RealmModel var1, Map<String, String> var2, Integer var3, Integer var4);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        return this.getGroupMembersStream(realm, group, null, null);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel var1, GroupModel var2, Integer var3, Integer var4);

    default public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, String search, Boolean exact, Integer first, Integer max) {
        Stream<UserModel> groupMembers = this.getGroupMembersStream(realm, group).filter(user -> {
            if (StringUtil.isBlank(search)) {
                return true;
            }
            if (Boolean.TRUE.equals(exact)) {
                return search.equals(user.getUsername()) || search.equals(user.getEmail()) || search.equals(user.getFirstName()) || search.equals(user.getLastName());
            }
            return Optional.ofNullable(user.getUsername()).orElse("").toLowerCase().contains(search.toLowerCase()) || Optional.ofNullable(user.getEmail()).orElse("").toLowerCase().contains(search.toLowerCase()) || Optional.ofNullable(user.getFirstName()).orElse("").toLowerCase().contains(search.toLowerCase()) || Optional.ofNullable(user.getLastName()).orElse("").toLowerCase().contains(search.toLowerCase());
        });
        if (first != null && first > 0) {
            groupMembers = groupMembers.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            groupMembers = groupMembers.limit(max.intValue());
        }
        return groupMembers;
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role) {
        return this.getRoleMembersStream(realm, role, null, null);
    }

    default public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel var1, String var2, String var3);
}

