/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreFactory;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.ui.graph.imex.StaxGraphReader;
import java.io.IOException;
import java.io.InputStream;

public class MaltegoGraphIO {
    private MaltegoGraphIO() {
    }

    public static void read(GraphID graphID, InputStream is, EntityFactory factory, EntityRegistry entityRegistry, LinkRegistry linkRegistry, IconRegistry iconRegistry) throws IOException {
        EntityRegistry.associate((GraphID)graphID, (EntityRegistry)entityRegistry);
        LinkRegistry.associate((GraphID)graphID, (LinkRegistry)linkRegistry);
        IconRegistry.associate((GraphID)graphID, (IconRegistry)iconRegistry);
        try {
            GraphStore graphStore = GraphStoreFactory.getDefault().create(graphID, false);
            graphStore.open();
        }
        catch (GraphStoreException ex) {
            throw new IOException(ex);
        }
        new StaxGraphReader(graphID, factory).read(is);
    }
}

