/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.merge;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MergeEntityPanel
extends JPanel {
    private final int THUMBNAIL_SIZE = 90;
    private final int NAME_MAX = 40;
    private GraphID _registryGraphID;
    private MaltegoEntity _entity;
    private Color _descriptionFg;
    private JLabel _imageLabel;
    private JLabel _linksLabel;
    private JLabel _propertiesLabel;
    private JLabel _typeDisplayLabel;
    private JLabel _typeLabel;
    private JLabel _valueLabel;
    private JPanel jPanel1;

    public MergeEntityPanel(GraphID graphID, GraphID registryGraphID, MaltegoEntity entity, String title) {
        String type;
        this._registryGraphID = registryGraphID;
        this._entity = entity;
        EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this._registryGraphID);
        this._descriptionFg = UIManager.getLookAndFeelDefaults().getColor("7-description-foreground");
        this.initComponents();
        this.setEntityIcon();
        String displayName = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)entity);
        if (StringUtilities.isNullOrEmpty((String)displayName)) {
            displayName = "<empty>";
        }
        if (displayName.length() > 40) {
            displayName = displayName.substring(0, 40) + "...";
        }
        this._valueLabel.setText(displayName);
        String displayType = type = entity.getTypeName();
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(type);
        if (spec != null) {
            displayType = spec.getDisplayName();
        }
        this._typeLabel.setText(type);
        this._typeDisplayLabel.setText(displayType);
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            int linkCount = structureReader.getLinkCount((EntityID)entity.getID());
            this._linksLabel.setText(linkCount + " links");
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this._propertiesLabel.setText(entity.getProperties().size() + " properties");
        this.setBorder(new TitledBorder(title));
    }

    private void setEntityIcon() {
        EntityImageFactory factory = EntityImageFactory.forGraph((GraphID)this._registryGraphID);
        Image image = factory.getImageMax(this._entity, 90, 90, (ImageCallback)new ThumbnailImageCallback());
        this._imageLabel.setText("");
        this._imageLabel.setIcon(ImageUtils.toIcon((Image)image));
    }

    private void initComponents() {
        this._imageLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this._typeDisplayLabel = new JLabel();
        this._typeLabel = new JLabel();
        this._valueLabel = new JLabel();
        this._linksLabel = new JLabel();
        this._propertiesLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this._imageLabel.setHorizontalAlignment(0);
        this._imageLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._imageLabel.text"));
        this.add((Component)this._imageLabel, "North");
        this.jPanel1.setPreferredSize(new Dimension(150, 75));
        this.jPanel1.setLayout(new GridLayout(0, 1));
        this._typeDisplayLabel.setFont(this._typeDisplayLabel.getFont().deriveFont((float)this._typeDisplayLabel.getFont().getSize() + 1.0f));
        this._typeDisplayLabel.setForeground(this._descriptionFg);
        this._typeDisplayLabel.setHorizontalAlignment(0);
        this._typeDisplayLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._typeDisplayLabel.text"));
        this.jPanel1.add(this._typeDisplayLabel);
        this._typeLabel.setFont(this._typeLabel.getFont().deriveFont((float)this._typeLabel.getFont().getSize() - 1.0f));
        this._typeLabel.setForeground(this._descriptionFg);
        this._typeLabel.setHorizontalAlignment(0);
        this._typeLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._typeLabel.text"));
        this.jPanel1.add(this._typeLabel);
        this._valueLabel.setFont(this._valueLabel.getFont().deriveFont((float)this._valueLabel.getFont().getSize() + 3.0f));
        this._valueLabel.setHorizontalAlignment(0);
        this._valueLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._valueLabel.text"));
        this.jPanel1.add(this._valueLabel);
        this._linksLabel.setFont(this._linksLabel.getFont().deriveFont((float)this._linksLabel.getFont().getSize() - 1.0f));
        this._linksLabel.setForeground(this._descriptionFg);
        this._linksLabel.setHorizontalAlignment(0);
        this._linksLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._linksLabel.text"));
        this.jPanel1.add(this._linksLabel);
        this._propertiesLabel.setFont(this._propertiesLabel.getFont().deriveFont((float)this._propertiesLabel.getFont().getSize() - 1.0f));
        this._propertiesLabel.setForeground(this._descriptionFg);
        this._propertiesLabel.setHorizontalAlignment(0);
        this._propertiesLabel.setText(NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel._propertiesLabel.text"));
        this.jPanel1.add(this._propertiesLabel);
        this.add((Component)this.jPanel1, "Center");
    }

    private class ThumbnailImageCallback
    implements ImageCallback {
        private ThumbnailImageCallback() {
        }

        public void imageReady(Image image) {
            MergeEntityPanel.this._imageLabel.setIcon(this.toIcon(image));
        }
    }
}

