/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.G.RA;
import yguard.A.G.n;
import yguard.A.I.M;
import yguard.A.I.R;
import yguard.A.I.T;
import yguard.A.J.SA;
import yguard.A.J.U;

public class MinimizeVisibleEntityMovementLayouter
implements n {
    private n _coreLayouter;
    private Map<Y, M> _beforeCenters;
    private Map<Y, Double> _weights;
    private static final boolean DEBUG = false;

    public MinimizeVisibleEntityMovementLayouter(U view) {
        this.initialize(view);
    }

    private void initialize(U view) {
        this._beforeCenters = this.getCentersOfVisibleNodes(view);
        this._weights = this.getWeights(view, this._beforeCenters);
        if (this._beforeCenters.isEmpty() && view.getGraph2D().v() > 0) {
            SA graph2D = view.getGraph2D();
            Y node = graph2D.\u00c1();
            this._beforeCenters.put(node, graph2D.P(node));
            this._weights.put(node, 1.0);
        }
    }

    public void setCoreLayouter(n layouter) {
        this._coreLayouter = layouter;
    }

    public boolean canLayout(RA lg) {
        return true;
    }

    public void doLayout(RA lg) {
        if (this._coreLayouter != null && this._coreLayouter.canLayout(lg)) {
            this._coreLayouter.doLayout(lg);
        }
        if (lg instanceof yguard.A.G.Y && !this._beforeCenters.isEmpty()) {
            yguard.A.G.Y copiedGraph = (yguard.A.G.Y)lg;
            double totalWeight = 0.0;
            double xDiff = 0.0;
            double yDiff = 0.0;
            for (Map.Entry<Y, M> entry : this._beforeCenters.entrySet()) {
                Y node = entry.getKey();
                Y copiedNode = copiedGraph.M((Object)node);
                if (copiedNode == null) continue;
                M centerBefore = entry.getValue();
                M centerAfter = lg.P(copiedNode);
                double weight = this._weights.get(node);
                xDiff += (centerBefore.A - centerAfter.A) * weight;
                yDiff += (centerBefore.D - centerAfter.D) * weight;
                totalWeight += weight;
            }
            if (totalWeight != 0.0) {
                xDiff /= totalWeight;
                yDiff /= totalWeight;
            }
            this.adjustNodeLocations(lg, xDiff, yDiff);
            this.adjustBendLocations(lg, xDiff, yDiff);
        }
    }

    private Map<Y, M> getCentersOfVisibleNodes(U view) {
        SA graph2D = view.getGraph2D();
        Rectangle visibleRect = view.getVisibleRect();
        HashMap<Y, M> centers = new HashMap<Y, M>();
        E nodes = graph2D.\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            M center = graph2D.P(node);
            if (visibleRect.contains(new Point2D.Double(center.A, center.D))) {
                centers.put(node, center);
            }
            nodes.next();
        }
        return centers;
    }

    private Map<Y, Double> getWeights(U view, Map<Y, M> centers) {
        SA graph2D = view.getGraph2D();
        Rectangle worldRect = view.getWorldRect();
        double worldCenterX = worldRect.getX() + worldRect.getWidth() / 2.0;
        double worldCenterY = worldRect.getY() + worldRect.getHeight() / 2.0;
        HashMap<Y, Double> weights = new HashMap<Y, Double>();
        for (Map.Entry<Y, M> entry : centers.entrySet()) {
            Y node = entry.getKey();
            M center = entry.getValue();
            double weight = 1.0 / (1.0 + Math.abs(center.A - worldCenterX) + Math.abs(center.D - worldCenterY));
            if (graph2D.g(node)) {
                weight += 1.0;
            }
            weights.put(node, weight);
        }
        return weights;
    }

    private void adjustNodeLocations(RA lg, double xAdjustment, double yAdjustment) {
        E nodes = lg.\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            lg.B(node, lg.U(node) + xAdjustment, lg.N(node) + yAdjustment);
            nodes.next();
        }
    }

    private void adjustBendLocations(RA lg, double xAdjustment, double yAdjustment) {
        Z edges = lg.u();
        while (edges.ok()) {
            H edge = edges.D();
            R path = lg.T(edge);
            T points = path.K();
            M[] newPath = new M[path.J()];
            int count = 0;
            while (points.ok()) {
                M point = points.R();
                newPath[count] = count == 0 || count == path.J() - 1 ? point : point.A(xAdjustment, yAdjustment);
                ++count;
                points.next();
            }
            lg.A(edge, new R(newPath));
            edges.next();
        }
    }

    private String format(M point) {
        return this.format(point.A) + "," + this.format(point.D);
    }

    private String format(double value) {
        return String.format("%10.5f", value);
    }

    private String fixLengthStr(Object obj, int length) {
        String tmp = obj.toString();
        while (tmp.length() < length) {
            tmp = tmp + " ";
        }
        return tmp.substring(0, length);
    }
}

