/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpMessage;
import org.xlightweb.BadMessageException;
import org.xlightweb.ContentType;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpHeader;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.NonBlockingBodyDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends AbstractHttpMessage
implements IHttpRequest {
    private static final Logger LOG = Logger.getLogger(HttpRequest.class.getName());
    private final IHttpRequestHeader requestHeader;
    private String requestHandlerPath = "";
    private String contextPath = "";

    public HttpRequest(IHttpRequestHeader requestHeader) {
        this.requestHeader = requestHeader;
        if (!HttpRequest.isBodylessRequestMethod(requestHeader.getMethod())) {
            requestHeader.setContentLength(0);
        }
    }

    public HttpRequest(IHttpRequestHeader requestHeader, NonBlockingBodyDataSource bodyDataSource) throws IOException {
        this.requestHeader = requestHeader;
        this.setBodyDataSource(bodyDataSource);
    }

    public HttpRequest(IHttpRequestHeader requestHeader, ByteBuffer[] bodyData) throws IOException {
        this.requestHeader = requestHeader;
        this.setBodyDataSource(bodyData, requestHeader.getCharacterEncoding());
    }

    public HttpRequest(String method, String url, String contentType, String body) throws IOException {
        this.requestHeader = new HttpRequestHeader(method, url, contentType);
        try {
            int length = this.setBodyDataSource(body, this.requestHeader.getCharacterEncoding());
            this.requestHeader.setContentLength(length);
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public HttpRequest(String method, String url, String contentType, String encoding, String body) throws IOException {
        if (HttpUtils.parseEncoding(contentType) == null) {
            contentType = contentType + "; charset=" + encoding;
        }
        this.requestHeader = new HttpRequestHeader(method, url, contentType);
        try {
            int length = this.setBodyDataSource(body, encoding);
            this.requestHeader.setContentLength(length);
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public HttpRequest(String method, String url, String contentType, byte[] body) throws IOException {
        this.requestHeader = new HttpRequestHeader(method, url, contentType);
        try {
            this.setBodyDataSource(new ByteBuffer[]{ByteBuffer.wrap(body)}, this.requestHeader.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public HttpRequest(String method, String url, String contentType, ByteBuffer[] body) throws IOException {
        this.requestHeader = new HttpRequestHeader(method, url, contentType);
        try {
            this.setBodyDataSource(body, this.requestHeader.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public HttpRequest(String method, String url) {
        this.requestHeader = new HttpRequestHeader(method, url);
        if (!HttpRequest.isBodylessRequestMethod(this.requestHeader.getMethod())) {
            this.requestHeader.setContentLength(0);
        }
    }

    @Override
    public IHttpRequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void addHeaderLine(String line) {
        this.getRequestHeader().addHeaderLine(line);
    }

    @Override
    public String getRequestHandlerPath() {
        return this.requestHandlerPath;
    }

    @Override
    public void setRequestHandlerPath(String requestHandlerPath) {
        this.requestHandlerPath = requestHandlerPath;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public void setMethod(String method) {
        this.getRequestHeader().setMethod(method);
    }

    @Override
    public String getMethod() {
        return this.getRequestHeader().getMethod();
    }

    @Override
    public List<ContentType> getAccept() {
        return this.getRequestHeader().getAccept();
    }

    @Override
    public void setHost(String host) {
        this.getRequestHeader().setHost(host);
    }

    @Override
    public String getServerName() {
        return this.getRequestHeader().getServerName();
    }

    @Override
    public int getServerPort() {
        return this.getRequestHeader().getServerPort();
    }

    @Override
    public String getProtocol() {
        return this.getRequestHeader().getProtocol();
    }

    @Override
    public String getProtocolVersion() {
        return this.getRequestHeader().getProtocolVersion();
    }

    @Override
    public URL getRequestUrl() {
        return this.getRequestHeader().getRequestUrl();
    }

    @Override
    public void setRequestUrl(URL url) {
        this.getRequestHeader().setRequestUrl(url);
    }

    @Override
    public String getRemoteHost() {
        return this.getRequestHeader().getRemoteHost();
    }

    @Override
    public String getRemoteAddr() {
        return this.getRequestHeader().getRemoteAddr();
    }

    @Override
    public int getRemotePort() {
        return this.getRequestHeader().getRemotePort();
    }

    @Override
    public String getRequestURI() {
        return this.getRequestHeader().getRequestURI();
    }

    @Override
    public void setRequestURI(String requestUri) {
        this.getRequestHeader().setRequestURI(requestUri);
    }

    @Override
    public String getPathInfo() {
        return this.getPathInfo(false);
    }

    @Override
    public String getPathInfo(boolean removeSurroundingSlashs) {
        String uri = this.getRequestURI();
        uri = uri.substring(this.getContextPath().length(), uri.length());
        uri = uri.substring(this.getRequestHandlerPath().length(), uri.length()).trim();
        if (removeSurroundingSlashs) {
            if (uri.startsWith("/")) {
                uri = uri.substring(1, uri.length());
            }
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1).trim();
            }
        } else if (!uri.startsWith("/")) {
            uri = "/" + uri.substring(1, uri.length());
        }
        return uri;
    }

    @Override
    public String getConnection() {
        return this.getRequestHeader().getConnection();
    }

    @Override
    public void setConnection(String connection) {
        this.getRequestHeader().setConnection(connection);
    }

    @Override
    public String getKeepAlive() {
        return this.getRequestHeader().getKeepAlive();
    }

    @Override
    public void setKeepAlive(String keepAlive) {
        this.getRequestHeader().setKeepAlive(keepAlive);
    }

    @Override
    public String getHost() {
        return this.getRequestHeader().getHost();
    }

    @Override
    public String getUpgrade() {
        return this.getRequestHeader().getUpgrade();
    }

    @Override
    public void setUpgrade(String upgrade) {
        this.getRequestHeader().setUpgrade(upgrade);
    }

    @Override
    public String getUserAgent() {
        return this.getRequestHeader().getUserAgent();
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.getRequestHeader().setUserAgent(userAgent);
    }

    @Override
    public String getQueryString() {
        return this.getRequestHeader().getQueryString();
    }

    @Override
    public boolean isSecure() {
        return this.getRequestHeader().isSecure();
    }

    @Override
    public Enumeration getParameterNames() {
        return this.getRequestHeader().getParameterNames();
    }

    @Override
    public Set<String> getParameterNameSet() {
        return this.getRequestHeader().getParameterNameSet();
    }

    @Override
    public String getParameter(String name) {
        return this.getRequestHeader().getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getRequestHeader().getParameterValues(name);
    }

    @Override
    public String getRequiredStringParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredStringParameter(name);
    }

    @Override
    public Integer getIntParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getIntParameter(name);
    }

    @Override
    public int getRequiredIntParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredIntParameter(name);
    }

    @Override
    public int getIntParameter(String name, int defaultVal) {
        return this.getRequestHeader().getIntParameter(name, defaultVal);
    }

    @Override
    public Long getLongParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getLongParameter(name);
    }

    @Override
    public long getRequiredLongParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredLongParameter(name);
    }

    @Override
    public long getLongParameter(String name, long defaultVal) {
        return this.getRequestHeader().getLongParameter(name, defaultVal);
    }

    @Override
    public Double getDoubleParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getDoubleParameter(name);
    }

    @Override
    public double getRequiredDoubleParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredDoubleParameter(name);
    }

    @Override
    public double getDoubleParameter(String name, double defaultVal) {
        return this.getRequestHeader().getDoubleParameter(name, defaultVal);
    }

    @Override
    public Float getFloatParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getFloatParameter(name);
    }

    @Override
    public float getRequiredFloatParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredFloatParameter(name);
    }

    @Override
    public float getFloatParameter(String name, float defaultVal) {
        return this.getRequestHeader().getFloatParameter(name, defaultVal);
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        return this.getRequestHeader().getBooleanParameter(name);
    }

    @Override
    public boolean getRequiredBooleanParameter(String name) throws BadMessageException {
        return this.getRequestHeader().getRequiredBooleanParameter(name);
    }

    @Override
    public boolean getBooleanParameter(String name, boolean defaultVal) {
        return this.getRequestHeader().getBooleanParameter(name, defaultVal);
    }

    @Override
    public void setParameter(String parameterName, String parameterValue) {
        this.getRequestHeader().setParameter(parameterName, parameterValue);
    }

    @Override
    public IHttpHeader getMessageHeader() {
        return this.requestHeader;
    }

    static String createFormUrlEncodedBody(String[] formParameters, String encoding) {
        StringBuilder sb = new StringBuilder();
        for (String param : formParameters) {
            try {
                int idx = param.indexOf("=");
                sb.append(URLEncoder.encode(param.substring(0, idx).trim(), encoding) + "=" + URLEncoder.encode(param.substring(idx + 1, param.length()).trim(), encoding) + "&");
            }
            catch (UnsupportedEncodingException usec) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured by encoding param " + param + " " + usec.toString());
            }
        }
        String body = sb.toString();
        if (body.length() > 0) {
            body = body.substring(0, body.length() - 1);
        }
        return body;
    }

    static boolean isBodylessRequestMethod(String method) {
        if (method.equals("GET")) {
            return true;
        }
        if (method.equals("POST")) {
            return false;
        }
        return method.equals("CONNECT") || method.equals("HEAD") || method.equals("TRACE") || method.equals("DELETE") || method.equals("OPTIONS");
    }
}

