/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import java.util.Collection;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public abstract class MachineMessageHandler {
    public static String TRANSFORM_PREFIX = "The transform";

    public static MachineMessageHandler getDefault() {
        Collection handlers = Lookup.getDefault().lookupAll(MachineMessageHandler.class);
        if (handlers == null || handlers.isEmpty()) {
            return new CommandlineMessageHandler();
        }
        if (handlers.size() == 1) {
            return (MachineMessageHandler)handlers.iterator().next();
        }
        return new MultiMachineMessageHandler(handlers);
    }

    public abstract void debug(DataObject var1, String var2, Object ... var3);

    public abstract void info(DataObject var1, String var2, Object ... var3);

    public abstract void note(DataObject var1, String var2, Object ... var3);

    public abstract void warning(DataObject var1, String var2, Object ... var3);

    public void error(DataObject target, Exception e) {
        this.error(target, "", e, new Object[0]);
    }

    public abstract void error(DataObject var1, String var2, Object ... var3);

    public void error(DataObject target, String message, Exception e, Object ... args) {
        if (message != null && e != null) {
            message = message + ": ";
        }
        if (e != null) {
            message = message + e.getMessage();
        }
        this.error(target, message, args);
    }

    protected String format(String message, Object ... args) {
        if (args != null && args.length > 0) {
            return String.format(message, args);
        }
        return message;
    }

    private static class MultiMachineMessageHandler
    extends MachineMessageHandler {
        private Collection<? extends MachineMessageHandler> _handlers;

        public MultiMachineMessageHandler(Collection<? extends MachineMessageHandler> handlers) {
            this._handlers = handlers;
        }

        @Override
        public void debug(DataObject target, String message, Object ... args) {
            for (MachineMessageHandler machineMessageHandler : this._handlers) {
                machineMessageHandler.debug(target, message, args);
            }
        }

        @Override
        public void info(DataObject target, String message, Object ... args) {
            for (MachineMessageHandler machineMessageHandler : this._handlers) {
                machineMessageHandler.info(target, message, args);
            }
        }

        @Override
        public void warning(DataObject target, String message, Object ... args) {
            for (MachineMessageHandler machineMessageHandler : this._handlers) {
                machineMessageHandler.warning(target, message, args);
            }
        }

        @Override
        public void error(DataObject target, String message, Object ... args) {
            for (MachineMessageHandler machineMessageHandler : this._handlers) {
                machineMessageHandler.error(target, message, args);
            }
        }

        @Override
        public void note(DataObject target, String message, Object ... args) {
            for (MachineMessageHandler machineMessageHandler : this._handlers) {
                machineMessageHandler.note(target, message, args);
            }
        }
    }

    private static class CommandlineMessageHandler
    extends MachineMessageHandler {
        private CommandlineMessageHandler() {
        }

        @Override
        public void debug(DataObject target, String message, Object ... args) {
            this.message("Debug", message, args);
        }

        @Override
        public void info(DataObject target, String message, Object ... args) {
            this.message("Info", message, args);
        }

        @Override
        public void warning(DataObject target, String message, Object ... args) {
            this.message("Warning", message, args);
        }

        @Override
        public void error(DataObject target, String message, Object ... args) {
            this.message("Error", message, args);
        }

        private void message(String level, String msg, Object ... args) {
            System.out.println(level + ": " + this.format(msg, args));
        }

        @Override
        public void note(DataObject target, String message, Object ... args) {
            this.message("Note", message, args);
        }
    }
}

