/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.NumericFilter;
import com.paterva.maltego.automation.actions.NumericFilterSupport;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import org.openide.util.Exceptions;

abstract class LinkCountFilter
extends NumericFilter {
    public LinkCountFilter(String name) {
        super(name);
    }

    private static class EntityFilterImpl
    extends NumericFilterSupport.NumericEntityFilter {
        private final LinkType _type;

        public EntityFilterImpl(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert, LinkType type) {
            super(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert);
            this._type = type;
        }

        private int getLinkCount(EntityID entityID) throws GraphStoreException {
            GraphID graphID = this.getContext().getTargetGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            switch (this._type) {
                case Incoming: {
                    return structureReader.getIncomingLinkCount(entityID);
                }
                case Outgoing: {
                    return structureReader.getOutgoingLinkCount(entityID);
                }
                case Both: {
                    return structureReader.getLinkCount(entityID);
                }
            }
            throw new IllegalArgumentException("Unknown link type: " + (Object)((Object)this._type));
        }

        @Override
        public boolean pass(MaltegoEntity entity) {
            boolean pass = false;
            try {
                int count = this.getLinkCount((EntityID)entity.getID());
                pass = NumericFilterSupport.check(count, this.getEqualTo(), this.getMoreThan(), this.getLessThan(), this.getMoreThanOrEqual(), this.getLessThanOrEqual());
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return pass;
        }
    }

    public static class Degree
    extends LinkCountFilter {
        public Degree() {
            super("degree");
        }

        @Override
        protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            return new EntityFilterImpl(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert, LinkType.Both);
        }
    }

    public static class Outgoing
    extends LinkCountFilter {
        public Outgoing() {
            super("outgoing");
        }

        @Override
        protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            return new EntityFilterImpl(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert, LinkType.Outgoing);
        }
    }

    public static class Incoming
    extends LinkCountFilter {
        public Incoming() {
            super("incoming");
        }

        @Override
        protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            return new EntityFilterImpl(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert, LinkType.Incoming);
        }
    }

    private static enum LinkType {
        Incoming,
        Outgoing,
        Both;

    }
}

