/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.treelist;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineManager;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.MachineRuntimeEvent;
import com.paterva.maltego.automation.MachineRuntimeListener;
import com.paterva.maltego.automation.RuntimeState;
import com.paterva.maltego.automation.favs.MachineFavorites;
import com.paterva.maltego.automation.treelist.MachineRunItem;
import com.paterva.maltego.automation.treelist.MachineRunningItem;
import com.paterva.maltego.automation.treelist.MachineSetItem;
import com.paterva.maltego.automation.treelist.MachinesItem;
import com.paterva.maltego.automation.treelist.NoMachinesItem;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.MachinesForNodes;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.runregistry.RunProvider;
import com.paterva.maltego.runregistry.favs.RunFavorites;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunProviderItemComparator;
import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.ui.graph.run.GlobalContextRunProvider;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class MachineRunProvider
extends GlobalContextRunProvider {
    private static final String FAVORITES = "Favorites";
    private static final String FAVORITES_LAF_PREFIX = "machines-item-fav";
    private final Map<String, Map<String, MachineRunItem>> _itemCache = new HashMap<String, Map<String, MachineRunItem>>();
    private final List<RunnableItem> _favorites = new ArrayList<RunnableItem>();

    public MachineRunProvider() {
        MachineManager.getDefault().addMachineListener(new MachineRunListener());
        MachineFavorites.getDefault().addPropertyChangeListener(new MachineFavoritesListener());
        MachineRepository.getDefault().addRepositoryListener(new MachineRepositoryListener());
        this.updateItems();
    }

    public int getPosition() {
        return 1000;
    }

    public static boolean isShowIn(String componentName) {
        return "run-view".equals(componentName) || "context-menu".equals(componentName);
    }

    public void run(List<RunProviderItem> items, GraphID graphID, Set<EntityID> entities) {
        MachineRunItem runItem;
        RunProviderItem item;
        if (items.size() == 1 && (item = items.iterator().next()) instanceof MachineRunItem && (runItem = (MachineRunItem)item).canRun()) {
            runItem.run(graphID, entities);
        }
    }

    protected void updateFavorites() {
        RunFavorites.getDefault().setFavorites((RunProvider)this, this._favorites);
    }

    protected List<RunProviderItem> createItems(String component, GraphID graphID, Set<EntityID> entities) {
        String filterText;
        List<MachineDescriptor> machines = null;
        try {
            machines = MachinesForNodes.get(graphID, entities);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this._favorites.clear();
        if (graphID == null || entities == null || !A.F()) {
            return Collections.EMPTY_LIST;
        }
        if (machines == null || machines.isEmpty()) {
            if (entities.isEmpty()) {
                machines = this.getNoInputEntityTypeMachines(graphID);
            }
            if (machines == null || machines.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        if (!StringUtilities.isNullOrEmpty((String)(filterText = this.getFilterText(component)))) {
            return this.toFilteredItems(filterText.toLowerCase(), machines, component);
        }
        return this.toItems(machines, component);
    }

    private List<MachineDescriptor> getNoInputEntityTypeMachines(GraphID graphID) {
        ArrayList<MachineDescriptor> machines = new ArrayList<MachineDescriptor>();
        try {
            MachineInputProvider inputProvider = MachineInputProvider.getDefault();
            for (MachineDescriptor machineDescriptor : MachineRepository.getDefault().getAll(true)) {
                MachineInput input = inputProvider.getInputDescriptor(machineDescriptor);
                if (!inputProvider.isNonInputEntityTypeMachines(input) || inputProvider.isLocalScope(machineDescriptor) || GraphStoreHelper.getEntityIDs((GraphID)graphID).isEmpty()) continue;
                machines.add(machineDescriptor);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return machines;
    }

    private List<RunProviderItem> toFilteredItems(String filterText, List<MachineDescriptor> machines, String component) {
        List<NoMachinesItem> rootItems = (machines = this.filter(filterText, machines)).isEmpty() ? Collections.singletonList(new NoMachinesItem()) : this.createMachineRunItems(machines, component);
        MachinesItem machinesItem = new MachinesItem(rootItems);
        return Collections.singletonList(machinesItem);
    }

    private List<MachineDescriptor> filter(String filterText, List<MachineDescriptor> machines) {
        return machines.stream().filter(machine -> this.filterKeepMachine(filterText, (MachineDescriptor)machine)).collect(Collectors.toList());
    }

    private boolean filterKeepMachine(String filterText, MachineDescriptor machine) {
        String displayName = machine.getDisplayName();
        return displayName != null && displayName.toLowerCase().contains(filterText);
    }

    private ArrayList<MachineRunItem> createMachineRunItems(List<MachineDescriptor> machines, String component) {
        ArrayList<MachineRunItem> machineRunItems = new ArrayList<MachineRunItem>();
        for (MachineDescriptor machine : machines) {
            MachineRunItem runItem = this.getMachineRunItem(machine, component);
            if (runItem.isFavorite()) {
                this._favorites.add((RunnableItem)runItem);
            }
            machineRunItems.add(runItem);
        }
        Collections.sort(machineRunItems, new RunProviderItemComparator());
        return machineRunItems;
    }

    private List<RunProviderItem> toItems(List<MachineDescriptor> machines, String component) {
        ArrayList<MachineRunItem> favs = new ArrayList<MachineRunItem>();
        for (MachineDescriptor machine : machines) {
            if (!machine.isFavorite()) continue;
            favs.add(this.getMachineRunItem(machine, component));
        }
        ArrayList<Object> items = new ArrayList<Object>();
        if (!favs.isEmpty()) {
            items.add((Object)new MachineSetItem(FAVORITES, favs, FAVORITES_LAF_PREFIX));
        }
        for (MachineDescriptor machine : machines) {
            MachineRunItem runItem = this.getMachineRunItem(machine, component);
            if (runItem.isFavorite()) {
                this._favorites.add((RunnableItem)runItem);
            }
            items.add((Object)runItem);
        }
        return Collections.singletonList(new MachinesItem(items));
    }

    private MachineRunItem getMachineRunItem(MachineDescriptor machine, String component) {
        String machineName;
        MachineRunItem runItem;
        Map<String, MachineRunItem> itemCacheForComponent = this._itemCache.get(component);
        if (itemCacheForComponent == null) {
            itemCacheForComponent = new HashMap<String, MachineRunItem>();
            this._itemCache.put(component, itemCacheForComponent);
        }
        if ((runItem = itemCacheForComponent.get(machineName = machine.getName())) == null) {
            runItem = new MachineRunItem(machineName, component);
            itemCacheForComponent.put(machineName, runItem);
        }
        return runItem;
    }

    private class MachineRepositoryListener
    implements RepositoryListener {
        private MachineRepositoryListener() {
        }

        public void onItemAdded(RepositoryEvent evt) {
            MachineRunProvider.this.updateItems();
        }

        public void onItemChanged(RepositoryEvent evt) {
            MachineRunProvider.this.updateItems();
        }

        public void onItemRemoved(RepositoryEvent evt) {
            MachineRunProvider.this.updateItems();
        }
    }

    private class MachineFavoritesListener
    implements PropertyChangeListener {
        private MachineFavoritesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MachineRunProvider.this.updateItems();
        }
    }

    private class MachineRunListener
    implements MachineRuntimeListener {
        private MachineRunListener() {
        }

        @Override
        public void machineProgress(MachineRuntimeEvent event) {
            MachineDescriptor machine = event.getMachine();
            MachineRunItem runItem = MachineRunProvider.this.getMachineRunItem(machine, "run-view");
            RuntimeState state = event.getState();
            switch (state) {
                case Running: 
                case Paused: 
                case Waiting: {
                    MachineRunningItem child = this.getOrCreateRunningItem(runItem);
                    child.setState(state);
                    String msg = event.getMessage();
                    if (msg == null) break;
                    child.setMessage(msg);
                    break;
                }
                case Cancelled: 
                case Completed: 
                case Failed: {
                    runItem.setChild(null);
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                MachineRunProvider.this.fireItemsChanged();
            } else {
                SwingUtilities.invokeLater(() -> MachineRunProvider.this.fireItemsChanged());
            }
        }

        private MachineRunningItem getOrCreateRunningItem(MachineRunItem runItem) {
            MachineRunningItem child = runItem.getChild();
            if (child == null) {
                child = new MachineRunningItem(runItem.getMachine());
                runItem.setChild(child);
            }
            return child;
        }
    }
}

