/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.look.Look;
import com.paterva.maltego.util.ui.look.ShadedPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.openide.util.NbBundle;

public class HeaderControl
extends ShadedPanel {
    private Action _action;
    private JLabel _title;

    public HeaderControl(Action action, Border outsideBorder, Color fontColor) {
        this(action, outsideBorder, fontColor, null);
    }

    public HeaderControl(Action action, Border outsideBorder, ActionCallback cb) {
        this(action, outsideBorder, UIManager.getLookAndFeelDefaults().getColor("transform-manager-panel-subheader-title"), cb);
    }

    public HeaderControl(Action action, Border outsideBorder, Color fontColor, final ActionCallback cb) {
        this.initComponents();
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this.setBackground(laf.getColor("transform-manager-panel-subheader-bg"));
        this.setShadeFactor(0.0);
        if (outsideBorder == null) {
            this.setBorder(Look.SUBHEADER_BORDER);
        } else {
            this.setBorder(new CompoundBorder(outsideBorder, Look.SUBHEADER_BORDER));
        }
        this._title.setForeground(fontColor);
        this._title.setFont(this._title.getFont().deriveFont(1));
        this._action = action;
        this._title.setText((String)this._action.getValue("Name"));
        this._title.setIcon((Icon)this._action.getValue("SmallIcon"));
        this._action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("Name".equals(evt.getPropertyName())) {
                    HeaderControl.this._title.setText((String)HeaderControl.this._action.getValue("Name"));
                } else if ("SmallIcon".equals(evt.getPropertyName())) {
                    HeaderControl.this._title.setIcon((Icon)HeaderControl.this._action.getValue("SmallIcon"));
                }
            }
        });
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                HeaderControl.this._action.actionPerformed(new ActionEvent(e.getSource(), 0, (String)HeaderControl.this._action.getValue("ActionCommandKey")));
                if (cb != null) {
                    cb.perform(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        if (cb != null) {
            cb.setMouseListener(mouseListener);
            cb.setTitle(this._title);
        }
        this._title.addMouseListener(mouseListener);
    }

    private void initComponents() {
        this._title = new JLabel();
        this.setPreferredSize(new Dimension(426, 25));
        this._title.setText(NbBundle.getMessage(HeaderControl.class, (String)"HeaderControl._title.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this._title).addContainerGap(396, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._title, -1, 30, Short.MAX_VALUE));
    }

    public static abstract class ActionCallback {
        private JXCollapsiblePane _collapsiblePane;
        private MouseListener _mouseListener;
        public JLabel _title;

        public void setCollapsiblePane(JXCollapsiblePane collapsiblePane) {
            this._collapsiblePane = collapsiblePane;
        }

        public JXCollapsiblePane getCollapsiblePane() {
            return this._collapsiblePane;
        }

        public void setMouseListener(MouseListener mouseListener) {
            this._mouseListener = mouseListener;
        }

        public MouseListener getMouseListener() {
            return this._mouseListener;
        }

        public void setTitle(JLabel title) {
            this._title = title;
        }

        public JLabel getTitle() {
            return this._title;
        }

        public abstract void perform(MouseEvent var1);
    }
}

