/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RoundRectLabel
extends JPanel {
    private final JLabel label = new JLabel();
    private final Color labelBg;
    private final RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    public RoundRectLabel(String text, Color labelBg, Color labelFg, boolean bold) {
        this.setOpaque(false);
        this.labelBg = labelBg;
        this.label.setText(text);
        if (labelFg != null) {
            this.label.setForeground(labelFg);
        }
        if (bold) {
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
        this.add(this.label);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color old = g2d.getColor();
        g2d.setColor(this.labelBg);
        g2d.setRenderingHints(this.hints);
        g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 20, 20);
        g2d.setColor(old);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }
}

