/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ui.table.ButtonNameProvider;
import com.paterva.maltego.util.ui.table.ModelDecorator;
import com.paterva.maltego.util.ui.table.RowModelDecorator;
import com.paterva.maltego.util.ui.table.RowTableModel;
import com.paterva.maltego.util.ui.table.TableButtonCallback;
import com.paterva.maltego.util.ui.table.TableButtonCellEditor;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import com.paterva.maltego.util.ui.table.TableModelDecorator;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;

public class EditableTableDecorator {
    private static final String ACTION_EDIT = "edit";
    private static final String ACTION_DELETE = "delete";
    private static Icon _deleteIcon;
    private static Icon _deleteDisabledIcon;
    private static Icon _editIcon;
    private static Icon _editDisabledIcon;

    public void addDelete(JTable table) {
        this.addDelete(table, null);
    }

    public void addDelete(JTable table, TableButtonCallback cb) {
        this.addDelete(table, false, true, cb);
    }

    public void addDelete(JTable table, boolean askSingleSelect, boolean askMulitSelect) {
        this.addEditDelete(table, askSingleSelect, askMulitSelect, null);
    }

    public void addDelete(JTable table, boolean askSingleSelect, boolean askMulitSelect, TableButtonCallback cb) {
        this.addEditDelete(table, askSingleSelect, askMulitSelect, null, cb);
    }

    public void addEdit(JTable table, TableButtonListener editHandler) {
        this.addEditDelete(table, null, editHandler);
    }

    public void addEdit(JTable table, TableButtonListener editHandler, TableButtonCallback cb) {
        this.addEditDelete(table, null, editHandler, cb);
    }

    public void addEditDelete(JTable table, boolean askSingleSelect, boolean askMulitSelect, TableButtonListener editHandler) {
        this.addEditDelete(table, askSingleSelect, askMulitSelect, editHandler, null);
    }

    public void addEditDelete(final JTable table, final boolean askSingleSelect, final boolean askMulitSelect, TableButtonListener editHandler, TableButtonCallback cb) {
        TableButtonListener deleteListener = new TableButtonListener(){

            @Override
            public void actionPerformed(TableButtonEvent evt) {
                TableModel delegate;
                TableModel model;
                if (evt.getSelectedRows() != null && evt.getSelectedRows().length > 0 && (model = table.getModel()) instanceof TableModelDecorator && (delegate = ((TableModelDecorator)model).getDelegate()) instanceof RowTableModel) {
                    RowTableModel rtm = (RowTableModel)delegate;
                    if (evt.getSelectedRows().length == 1) {
                        if (askSingleSelect) {
                            if (this.ask()) {
                                rtm.removeRow(evt.getSelectedRows()[0]);
                            }
                        } else {
                            rtm.removeRow(evt.getSelectedRows()[0]);
                        }
                    } else if (askMulitSelect) {
                        if (this.ask()) {
                            rtm.removeRows(evt.getSelectedRows());
                        }
                    } else {
                        rtm.removeRows(evt.getSelectedRows());
                    }
                }
            }

            private boolean ask() {
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)"Delete selected row(s)?", "Delete selection", 1, 3, null, NotifyDescriptor.YES_OPTION)) == NotifyDescriptor.YES_OPTION;
            }
        };
        this.addEditDelete(table, deleteListener, editHandler, cb);
    }

    public void addEditDelete(JTable table, TableButtonListener deleteHandler, TableButtonListener editHandler) {
        this.addEditDelete(table, deleteHandler, editHandler, null);
    }

    public void addEditDelete(JTable table, final TableButtonListener deleteHandler, final TableButtonListener editHandler, TableButtonCallback cb) {
        int count = 0;
        if (deleteHandler != null) {
            ++count;
        }
        if (editHandler != null) {
            ++count;
        }
        JButton[] buttons = new JButton[count];
        boolean[] multiSelect = new boolean[count];
        boolean[] drawBorder = new boolean[count];
        int index = 0;
        if (editHandler != null) {
            buttons[index] = this.createEditButton();
            multiSelect[index] = false;
            drawBorder[index] = false;
            ++index;
        }
        if (deleteHandler != null) {
            buttons[index] = this.createDeleteButton();
            multiSelect[index] = true;
            drawBorder[index] = false;
            ++index;
        }
        TableButtonListener listener = new TableButtonListener(){

            @Override
            public void actionPerformed(TableButtonEvent evt) {
                if (EditableTableDecorator.ACTION_DELETE.equals(evt.getActionCommand())) {
                    deleteHandler.actionPerformed(evt);
                } else if (EditableTableDecorator.ACTION_EDIT.equals(evt.getActionCommand())) {
                    editHandler.actionPerformed(evt);
                }
            }
        };
        Object[] cbs = new TableButtonCallback[buttons.length];
        Arrays.fill(cbs, cb);
        this.addTableButtons(table, listener, buttons, multiSelect, drawBorder, (TableButtonCallback[])cbs, null);
    }

    public JButton createEditButton() {
        return EditableTableDecorator.createButton(ACTION_EDIT, EditableTableDecorator.editIcon(), EditableTableDecorator.editDisabledIcon());
    }

    public JButton createDeleteButton() {
        return EditableTableDecorator.createButton(ACTION_DELETE, EditableTableDecorator.deleteIcon(), EditableTableDecorator.deleteDisabledIcon());
    }

    private static JButton createButton(String action, Icon enabled, Icon disabled) {
        JButton button = new JButton(enabled);
        button.setDisabledIcon(disabled);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorderPainted(false);
        button.setActionCommand(action);
        button.setContentAreaFilled(false);
        Dimension size = new Dimension(enabled.getIconWidth(), enabled.getIconHeight());
        button.setPreferredSize(size);
        button.setMinimumSize(size);
        button.setMaximumSize(size);
        return button;
    }

    private static Icon deleteIcon() {
        if (_deleteIcon == null) {
            _deleteIcon = new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/table/delete.png"));
        }
        return _deleteIcon;
    }

    private static Icon deleteDisabledIcon() {
        if (_deleteDisabledIcon == null) {
            _deleteDisabledIcon = new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/table/deleteDisabled.png"));
        }
        return _deleteDisabledIcon;
    }

    private static Icon editIcon() {
        if (_editIcon == null) {
            _editIcon = new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/table/editDark.png"));
        }
        return _editIcon;
    }

    private static Icon editDisabledIcon() {
        if (_editDisabledIcon == null) {
            _editDisabledIcon = new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/table/editDisabled.png"));
        }
        return _editDisabledIcon;
    }

    public void addTableButtons(JTable table, TableButtonListener listener, JButton[] buttons, boolean[] multiSelect, boolean[] drawBorder, ButtonNameProvider nameProvider) {
        this.addTableButtons(table, listener, buttons, multiSelect, drawBorder, new TableButtonCallback[buttons.length], nameProvider);
    }

    public void addTableButtons(JTable table, TableButtonListener listener, JButton[] buttons, boolean[] multiSelect, boolean[] drawBorder, TableButtonCallback[] cb, ButtonNameProvider nameProvider) {
        TableModel model = table.getModel();
        table.setModel(new TableModelDecorator(model, this.getActions(buttons)));
        final TableButtonCellEditor bce = new TableButtonCellEditor(listener, buttons, multiSelect, drawBorder, cb, nameProvider);
        table.setDefaultRenderer(ModelDecorator.ActionDecorator.class, bce);
        table.setDefaultEditor(ModelDecorator.ActionDecorator.class, bce);
        table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                bce.setRowOver(table.rowAtPoint(e.getPoint()));
                bce.setColOver(table.columnAtPoint(e.getPoint()));
                table.repaint();
            }
        });
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                bce.setRowOver(-1);
                bce.setColOver(-1);
                table.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
        this.sizeColumnsToButtons(table, buttons);
    }

    private void sizeColumnsToButtons(JTable table, JButton[] buttons) {
        TableColumnModel colModel = table.getColumnModel();
        int origColCount = colModel.getColumnCount() - buttons.length;
        for (int i = 0; i < buttons.length; ++i) {
            TableColumn col = colModel.getColumn(i + origColCount);
            col.setHeaderRenderer(new HeaderRenderer());
            JButton button = buttons[i];
            int prefWidth = button.getPreferredSize().width + 2;
            col.setResizable(false);
            col.setMaxWidth(prefWidth);
            col.setMinWidth(prefWidth);
        }
    }

    public void addTableButtons(Outline table, TableButtonListener listener, JButton[] buttons, boolean[] multiSelect, boolean[] drawBorder) {
        final TableButtonCellEditor bce = new TableButtonCellEditor(listener, buttons, multiSelect, drawBorder);
        table.setDefaultRenderer(ModelDecorator.ActionDecorator.class, (TableCellRenderer)bce);
        table.setDefaultEditor(ModelDecorator.ActionDecorator.class, (TableCellEditor)bce);
        table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                bce.setRowOver(table.rowAtPoint(e.getPoint()));
                bce.setColOver(table.columnAtPoint(e.getPoint()));
                table.repaint();
            }
        });
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                bce.setRowOver(-1);
                bce.setColOver(-1);
                table.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
    }

    public OutlineModel createDecoratedOutlineModel(TreeModel treeModel, RowModel rowModel, boolean isLarge, String nodesColumnLabel, JButton[] buttons) {
        return DefaultOutlineModel.createOutlineModel((TreeModel)treeModel, (RowModel)new RowModelDecorator(rowModel, this.getActions(buttons)), (boolean)isLarge, (String)nodesColumnLabel);
    }

    public void addTableButtons(Outline table, TreeModel treeModel, RowModel rowModel, boolean isLarge, String nodesColumnLabel, TableButtonListener listener, JButton[] buttons, boolean[] multiSelect, boolean[] drawBorder) {
        table.setModel((TableModel)this.createDecoratedOutlineModel(treeModel, rowModel, isLarge, nodesColumnLabel, buttons));
        this.addTableButtons(table, listener, buttons, multiSelect, drawBorder);
    }

    private String[] getActions(JButton[] buttons) {
        String[] actions = new String[buttons.length];
        for (int i = 0; i < buttons.length; ++i) {
            actions[i] = buttons[i].getActionCommand();
        }
        return actions;
    }

    class HeaderRenderer
    extends DefaultTableCellRenderer {
        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JTableHeader h;
            JTableHeader jTableHeader = h = table != null ? table.getTableHeader() : null;
            if (h != null) {
                this.setEnabled(h.isEnabled());
                this.setComponentOrientation(h.getComponentOrientation());
                this.setForeground(h.getForeground());
                this.setBackground(h.getBackground());
                this.setFont(h.getFont());
            } else {
                this.setEnabled(true);
                this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            this.setValue("");
            return this;
        }
    }
}

