/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.icons;

import com.paterva.maltego.imgfactory.icons.IconSelectorPanel;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public abstract class IconSelector {
    public static IconSelector getDefault() {
        IconSelector selector = (IconSelector)Lookup.getDefault().lookup(IconSelector.class);
        if (selector == null) {
            selector = new DefaultIconSelector();
        }
        return selector;
    }

    public RegistryIcon getIcon(IconSize size, RegistryIcon selection) {
        return this.getIcon(size, IconRegistry.getDefault(), selection);
    }

    public RegistryIcon getIcon(IconSize size, String iconCategory) {
        return this.getIcon(size, IconRegistry.getDefault(), iconCategory);
    }

    public abstract RegistryIcon getIcon(IconSize var1, IconRegistry var2, RegistryIcon var3);

    public abstract RegistryIcon getIcon(IconSize var1, IconRegistry var2, String var3);

    private static class DefaultIconSelector
    extends IconSelector {
        private DefaultIconSelector() {
        }

        @Override
        public RegistryIcon getIcon(IconSize size, IconRegistry iconRegistry, RegistryIcon selection) {
            IconSelectorPanel panel = this.createPanel(iconRegistry, size);
            panel.setSelectedIcon(selection);
            return this.showPanel(panel);
        }

        @Override
        public RegistryIcon getIcon(IconSize size, IconRegistry iconRegistry, String defaultCategory) {
            IconSelectorPanel panel = this.createPanel(iconRegistry, size);
            panel.setSelectedCategory(defaultCategory);
            return this.showPanel(panel);
        }

        private IconSelectorPanel createPanel(IconRegistry iconRegistry, IconSize size) {
            IconSelectorPanel panel = new IconSelectorPanel();
            panel.setIconRegistry(iconRegistry);
            panel.setIconSize(size);
            return panel;
        }

        private RegistryIcon showPanel(IconSelectorPanel panel) {
            PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
            outerPanel.add(panel);
            DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, "Choose an icon");
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                return panel.getSelectedIcon();
            }
            return null;
        }
    }
}

