/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre;

import java.io.IOException;
import java.io.InputStream;

public class StringUtils {
    public static final String NEW_LINE_PATTERN = "(?:\r\n|\n|\r)";

    public static String asString(Object[] objects, String separator) {
        return StringUtils.asString(objects, 0, objects.length, separator);
    }

    public static String asString(Object[] objects, int offset, int length, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            result.append(objects[i].toString());
            if (i == offset + length - 1) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String readStream(InputStream stream) throws IOException {
        return StringUtils.readStream(stream, null);
    }

    public static String readStream(InputStream stream, String charset) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[1024];
        while (stream.available() > 0) {
            int read = stream.read(buffer);
            String readString = charset == null ? new String(buffer, 0, read) : new String(buffer, 0, read, charset);
            String[] strings = StringUtils.splitByLines(readString);
            for (int i = 0; i < strings.length; ++i) {
                builder.append(strings[i]);
                if (i == strings.length - 1) continue;
                builder.append(System.getProperty("line.separator"));
            }
        }
        return builder.toString();
    }

    public static String[] splitByLines(String s) {
        return s.split(NEW_LINE_PATTERN, -1);
    }
}

