/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import org.apache.lucene.rangetree.HeapSliceReader;
import org.apache.lucene.rangetree.SliceReader;
import org.apache.lucene.rangetree.SliceWriter;
import org.apache.lucene.util.ArrayUtil;

final class GrowingHeapSliceWriter
implements SliceWriter {
    long[] values = new long[16];
    int[] docIDs = new int[16];
    long[] ords = new long[16];
    private int nextWrite;
    final int maxSize;

    public GrowingHeapSliceWriter(int maxSize) {
        this.maxSize = maxSize;
    }

    private int[] growExact(int[] arr, int size) {
        assert (size > arr.length);
        int[] newArr = new int[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    private long[] growExact(long[] arr, int size) {
        assert (size > arr.length);
        long[] newArr = new long[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    @Override
    public void append(long value, long ord, int docID) {
        assert (ord == (long)this.nextWrite);
        if (this.values.length == this.nextWrite) {
            int nextSize = Math.min(this.maxSize, ArrayUtil.oversize((int)(this.nextWrite + 1), (int)4));
            assert (nextSize > this.nextWrite) : "nextSize=" + nextSize + " vs nextWrite=" + this.nextWrite;
            this.values = this.growExact(this.values, nextSize);
            this.ords = this.growExact(this.ords, nextSize);
            this.docIDs = this.growExact(this.docIDs, nextSize);
        }
        this.values[this.nextWrite] = value;
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public SliceReader getReader(long start) {
        return new HeapSliceReader(this.values, this.ords, this.docIDs, (int)start, this.nextWrite);
    }

    @Override
    public void close() {
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "GrowingHeapSliceWriter(count=" + this.nextWrite + " alloc=" + this.values.length + ")";
    }
}

