/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextExpression;
import com.oracle.js.parser.ir.LexicalContextScope;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.Scope;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class ClassNode
extends LexicalContextExpression
implements LexicalContextScope {
    private final IdentNode ident;
    private final Expression classHeritage;
    private final PropertyNode constructor;
    private final List<PropertyNode> classElements;
    private final Scope scope;
    private final int instanceFieldCount;
    private final int staticElementCount;
    private final boolean hasPrivateMethods;
    private final boolean hasPrivateInstanceMethods;
    public static final String PRIVATE_CONSTRUCTOR_BINDING_NAME = "#constructor";

    public ClassNode(long token, int finish, IdentNode ident, Expression classHeritage, PropertyNode constructor, List<PropertyNode> classElements, Scope scope, int instanceFieldCount, int staticElementCount, boolean hasPrivateMethods, boolean hasPrivateInstanceMethods) {
        super(token, finish);
        this.ident = ident;
        this.classHeritage = classHeritage;
        this.constructor = constructor;
        this.classElements = classElements;
        this.scope = scope;
        this.instanceFieldCount = instanceFieldCount;
        this.staticElementCount = staticElementCount;
        this.hasPrivateMethods = hasPrivateMethods;
        this.hasPrivateInstanceMethods = hasPrivateInstanceMethods;
        assert (instanceFieldCount == ClassNode.elementCount(classElements, false));
        assert (staticElementCount == ClassNode.elementCount(classElements, true));
    }

    private ClassNode(ClassNode classNode, IdentNode ident, Expression classHeritage, PropertyNode constructor, List<PropertyNode> classElements) {
        super(classNode);
        this.ident = ident;
        this.classHeritage = classHeritage;
        this.constructor = constructor;
        this.classElements = classElements;
        this.scope = classNode.scope;
        this.instanceFieldCount = ClassNode.elementCount(classElements, false);
        this.staticElementCount = ClassNode.elementCount(classElements, true);
        this.hasPrivateMethods = classNode.hasPrivateMethods;
        this.hasPrivateInstanceMethods = classNode.hasPrivateInstanceMethods;
    }

    private static int elementCount(List<PropertyNode> classElements, boolean isStatic) {
        int count = 0;
        for (PropertyNode classElement : classElements) {
            if (classElement.isStatic() != isStatic || !classElement.isClassField() && !classElement.isClassStaticBlock()) continue;
            ++count;
        }
        return count;
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    private ClassNode setIdent(IdentNode ident) {
        if (this.ident == ident) {
            return this;
        }
        return new ClassNode(this, ident, this.classHeritage, this.constructor, this.classElements);
    }

    public Expression getClassHeritage() {
        return this.classHeritage;
    }

    private ClassNode setClassHeritage(Expression classHeritage) {
        if (this.classHeritage == classHeritage) {
            return this;
        }
        return new ClassNode(this, this.ident, classHeritage, this.constructor, this.classElements);
    }

    public PropertyNode getConstructor() {
        return this.constructor;
    }

    public ClassNode setConstructor(PropertyNode constructor) {
        if (this.constructor == constructor) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, constructor, this.classElements);
    }

    public List<PropertyNode> getClassElements() {
        return Collections.unmodifiableList(this.classElements);
    }

    public ClassNode setClassElements(List<PropertyNode> classElements) {
        if (this.classElements == classElements) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, this.constructor, classElements);
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterClassNode(this)) {
            IdentNode newIdent = this.ident == null ? null : (IdentNode)this.ident.accept(visitor);
            Expression newClassHeritage = this.classHeritage == null ? null : (Expression)this.classHeritage.accept(visitor);
            PropertyNode newConstructor = this.constructor == null ? null : (PropertyNode)this.constructor.accept(visitor);
            List<PropertyNode> newClassElements = Node.accept(visitor, this.classElements);
            return visitor.leaveClassNode(this.setIdent(newIdent).setClassHeritage(newClassHeritage).setConstructor(newConstructor).setClassElements(newClassElements));
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lc, TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterClassNode(this);
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public boolean hasInstanceFields() {
        return this.instanceFieldCount != 0;
    }

    public int getInstanceFieldCount() {
        return this.instanceFieldCount;
    }

    public boolean hasStaticElements() {
        return this.staticElementCount != 0;
    }

    public int getStaticElementCount() {
        return this.staticElementCount;
    }

    public boolean hasPrivateMethods() {
        return this.hasPrivateMethods;
    }

    public boolean hasPrivateInstanceMethods() {
        return this.hasPrivateInstanceMethods;
    }

    public boolean isAnonymous() {
        return this.getIdent() == null;
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("class");
        if (this.ident != null) {
            sb.append(' ');
            this.ident.toString(sb, printType);
        }
        if (this.classHeritage != null) {
            sb.append(" extends ");
            this.classHeritage.toString(sb, printType);
        }
        sb.append(" {");
        if (this.constructor != null) {
            this.constructor.toString(sb, printType);
        }
        for (PropertyNode classElement : this.getClassElements()) {
            sb.append(", ");
            classElement.toString(sb, printType);
        }
        sb.append("}");
    }
}

