/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import org.apache.lucene.bkdtree3d.Reader;

final class HeapReader
implements Reader {
    private int curRead;
    final int[] xs;
    final int[] ys;
    final int[] zs;
    final long[] ords;
    final int[] docIDs;
    final int end;

    HeapReader(int[] xs, int[] ys, int[] zs, long[] ords, int[] docIDs, int start, int end) {
        this.xs = xs;
        this.ys = ys;
        this.zs = zs;
        this.ords = ords;
        this.docIDs = docIDs;
        this.curRead = start - 1;
        this.end = end;
    }

    @Override
    public boolean next() {
        ++this.curRead;
        return this.curRead < this.end;
    }

    @Override
    public int x() {
        return this.xs[this.curRead];
    }

    @Override
    public int y() {
        return this.ys[this.curRead];
    }

    @Override
    public int z() {
        return this.zs[this.curRead];
    }

    @Override
    public int docID() {
        return this.docIDs[this.curRead];
    }

    @Override
    public long ord() {
        return this.ords[this.curRead];
    }

    @Override
    public void close() {
    }
}

