/*
 * Decompiled with CFR 0.152.
 */
package org.openide.io;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.io.Bundle;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOContainer;
import org.openide.windows.IOFolding;
import org.openide.windows.IOPosition;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class BridgingIOProvider<IO, S extends PrintWriter, P, F>
extends IOProvider {
    private static final Logger LOG = Logger.getLogger(BridgingIOProvider.class.getName());
    private static final Set<ShowOperation> DEFAULT_SHOW_OPERATIONS = EnumSet.of(ShowOperation.OPEN, ShowOperation.MAKE_VISIBLE);
    private final InputOutputProvider<IO, S, P, F> providerDelegate;
    private Lookup lookup = null;

    public static <A, B extends PrintWriter, C, D> IOProvider create(InputOutputProvider<A, B, C, D> delegate) {
        return new BridgingIOProvider<A, B, C, D>(delegate);
    }

    private BridgingIOProvider(InputOutputProvider<IO, S, P, F> delegate) {
        this.providerDelegate = delegate;
    }

    @Override
    public InputOutput getIO(String name, boolean newIO) {
        return new BridgingInputOutput(this.providerDelegate.getIO(name, newIO, Lookup.EMPTY));
    }

    @Override
    public InputOutput getIO(String name, Action[] actions) {
        return new BridgingInputOutput(this.providerDelegate.getIO(name, true, Lookups.fixed((Object[])actions)));
    }

    @Override
    public InputOutput getIO(String name, Action[] actions, IOContainer ioContainer) {
        return this.getIO(name, true, actions, ioContainer);
    }

    @Override
    public InputOutput getIO(String name, boolean newIO, Action[] actions, IOContainer ioContainer) {
        Action[] lookupContent;
        if (ioContainer != null) {
            lookupContent = Arrays.copyOf(actions, actions.length + 1, Object[].class);
            lookupContent[actions.length] = ioContainer;
        } else {
            lookupContent = actions;
        }
        return new BridgingInputOutput(this.providerDelegate.getIO(name, newIO, Lookups.fixed((Object[])lookupContent)));
    }

    @Override
    public OutputWriter getStdOut() {
        Object io = this.providerDelegate.getIO(Bundle.LBL_STDOUT(), false, Lookup.EMPTY);
        PrintWriter out = this.providerDelegate.getOut(io);
        return new BridgingOutputWriter(this, io, out);
    }

    private Hyperlink listenerToHyperlink(final OutputListener l, boolean important) {
        return l == null ? null : Hyperlink.from((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    l.outputLineAction(null);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Cannot process output listener action", e);
                }
            }
        }, (boolean)important);
    }

    private class BridgingIOFolding
    extends IOFolding {
        private final IO ioDelegate;

        public BridgingIOFolding(IO ioDelegate) {
            this.ioDelegate = ioDelegate;
        }

        @Override
        protected IOFolding.FoldHandleDefinition startFold(boolean expanded) {
            PrintWriter writer = BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate);
            Object fold = BridgingIOProvider.this.providerDelegate.startFold(this.ioDelegate, writer, expanded);
            return new BridgingFoldHandleDefinition(this, writer, fold);
        }

        private static class BridgingFoldHandleDefinition
        extends IOFolding.FoldHandleDefinition {
            private final S writer;
            private final F fold;
            final /* synthetic */ BridgingIOFolding this$1;

            public BridgingFoldHandleDefinition(S writer, F fold) {
                this.this$1 = var1_1;
                this.writer = writer;
                this.fold = fold;
            }

            @Override
            public void finish() {
                this.this$1.BridgingIOProvider.this.providerDelegate.endFold(this.this$1.ioDelegate, this.writer, this.fold);
            }

            @Override
            public IOFolding.FoldHandleDefinition startFold(boolean expanded) {
                Object f = this.this$1.BridgingIOProvider.this.providerDelegate.startFold(this.this$1.ioDelegate, this.writer, expanded);
                return new BridgingFoldHandleDefinition(this.this$1, this.writer, f);
            }

            @Override
            public void setExpanded(boolean expanded) {
                this.this$1.BridgingIOProvider.this.providerDelegate.setFoldExpanded(this.this$1.ioDelegate, this.writer, this.fold, expanded);
            }
        }
    }

    private class BridgingIOPosition
    extends IOPosition {
        private final IO ioDelegate;

        public BridgingIOPosition(IO ioDelegate) {
            this.ioDelegate = ioDelegate;
        }

        @Override
        protected IOPosition.Position currentPosition() {
            final PrintWriter writer = BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate);
            final Object pos = BridgingIOProvider.this.providerDelegate.getCurrentPosition(this.ioDelegate, writer);
            return new IOPosition.Position(){

                @Override
                public void scrollTo() {
                    BridgingIOProvider.this.providerDelegate.scrollTo(BridgingIOPosition.this.ioDelegate, writer, pos);
                }
            };
        }
    }

    private class BridgingIOColorPrint
    extends IOColorPrint {
        private final IO ioDelegate;

        public BridgingIOColorPrint(IO ioDelegate) {
            this.ioDelegate = ioDelegate;
        }

        @Override
        protected void print(CharSequence text, OutputListener listener, boolean important, Color color) throws IOException {
            Hyperlink h = BridgingIOProvider.this.listenerToHyperlink(listener, important);
            OutputColor outColor = color == null ? null : OutputColor.rgb((int)color.getRGB());
            BridgingIOProvider.this.providerDelegate.print(this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate), text.toString(), h, outColor, false);
        }
    }

    private class BridgingIOColorLines
    extends IOColorLines {
        private final IO ioDelegate;

        public BridgingIOColorLines(IO ioDelegate) {
            this.ioDelegate = ioDelegate;
        }

        @Override
        protected void println(CharSequence text, OutputListener listener, boolean important, Color color) throws IOException {
            Hyperlink h = BridgingIOProvider.this.listenerToHyperlink(listener, important);
            BridgingIOProvider.this.providerDelegate.print(this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate), text.toString(), h, null, true);
        }
    }

    private static class BridgingOutputWriter
    extends OutputWriter {
        PrintWriter printWriterToReplace;
        private final S writerDelegate;
        private final IO ioDelegate;
        final /* synthetic */ BridgingIOProvider this$0;

        public BridgingOutputWriter(IO ioDelegate, S delegate) {
            this.this$0 = var1_1;
            super((Writer)delegate);
            this.printWriterToReplace = null;
            this.writerDelegate = delegate;
            this.ioDelegate = ioDelegate;
        }

        @Override
        public void println(String s, OutputListener l) throws IOException {
            this.println(s, l, false);
        }

        @Override
        public void println(String s, OutputListener l, boolean important) throws IOException {
            Hyperlink h = this.this$0.listenerToHyperlink(l, important);
            this.this$0.providerDelegate.print(this.ioDelegate, this.writerDelegate, s, h, null, true);
        }

        @Override
        public void reset() throws IOException {
            this.this$0.providerDelegate.resetIO(this.ioDelegate);
        }
    }

    private class BridgingInputOutput
    implements InputOutput,
    Lookup.Provider {
        private final IO ioDelegate;

        public BridgingInputOutput(IO delegate) {
            this.ioDelegate = delegate;
        }

        @Override
        public OutputWriter getOut() {
            return new BridgingOutputWriter(BridgingIOProvider.this, this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate));
        }

        @Override
        public Reader getIn() {
            return BridgingIOProvider.this.providerDelegate.getIn(this.ioDelegate);
        }

        @Override
        public OutputWriter getErr() {
            return new BridgingOutputWriter(BridgingIOProvider.this, this.ioDelegate, BridgingIOProvider.this.providerDelegate.getOut(this.ioDelegate));
        }

        @Override
        public void closeInputOutput() {
            BridgingIOProvider.this.providerDelegate.closeIO(this.ioDelegate);
        }

        @Override
        public boolean isClosed() {
            return BridgingIOProvider.this.providerDelegate.isIOClosed(this.ioDelegate);
        }

        @Override
        public void setOutputVisible(boolean value) {
        }

        @Override
        public void setErrVisible(boolean value) {
        }

        @Override
        public void setInputVisible(boolean value) {
        }

        @Override
        public void select() {
            BridgingIOProvider.this.providerDelegate.showIO(this.ioDelegate, DEFAULT_SHOW_OPERATIONS);
        }

        @Override
        public boolean isErrSeparated() {
            return false;
        }

        @Override
        public void setErrSeparated(boolean value) {
        }

        @Override
        public boolean isFocusTaken() {
            return false;
        }

        @Override
        public void setFocusTaken(boolean value) {
        }

        @Override
        public Reader flushReader() {
            return this.getIn();
        }

        public synchronized Lookup getLookup() {
            if (BridgingIOProvider.this.lookup == null) {
                Lookup origLookup = BridgingIOProvider.this.providerDelegate.getIOLookup(this.ioDelegate);
                Lookup extLookup = Lookups.fixed((Object[])new Object[]{new BridgingIOColorLines(this.ioDelegate), new BridgingIOColorPrint(this.ioDelegate), new BridgingIOPosition(this.ioDelegate), new BridgingIOFolding(this.ioDelegate)});
                if (origLookup == Lookup.EMPTY) {
                    BridgingIOProvider.this.lookup = extLookup;
                } else {
                    BridgingIOProvider.this.lookup = (Lookup)new ProxyLookup(new Lookup[]{origLookup, extLookup});
                }
            }
            return BridgingIOProvider.this.lookup;
        }
    }
}

